/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.row.BaseTypeSpec;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite.internal.sql.engine.exec.row.RowSchemaTypes;
import org.apache.ignite.internal.sql.engine.exec.row.RowType;
import org.apache.ignite.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomType;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeCoercionRules;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.SafeCustomTypeInternalConversion;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.type.VarlenNativeType;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    public static final BiFunction<Integer, Object, Object> BI_FUNCTION_IDENTITY_SECOND_ARGUMENT = (idx, r) -> r;
    private static final Set<SqlTypeName> CONVERTABLE_TYPES = EnumSet.of(SqlTypeName.DATE, new SqlTypeName[]{SqlTypeName.TIME, SqlTypeName.BINARY, SqlTypeName.VARBINARY, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, SqlTypeName.INTERVAL_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_MINUTE_SECOND, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_HOUR_MINUTE, SqlTypeName.INTERVAL_HOUR_SECOND, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_DAY_HOUR, SqlTypeName.INTERVAL_DAY_MINUTE, SqlTypeName.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_YEAR, SqlTypeName.INTERVAL_YEAR_MONTH});

    private static Set<Class<?>> supportedParamClasses() {
        return SupportedParamClassesHolder.SUPPORTED_PARAM_CLASSES;
    }

    public static boolean supportParamInstance(@Nullable Object param) {
        return param == null || TypeUtils.supportedParamClasses().contains(param.getClass());
    }

    public static RelDataType combinedRowType(IgniteTypeFactory typeFactory, RelDataType ... types) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        HashSet<String> names = new HashSet<String>();
        for (RelDataType type : types) {
            for (RelDataTypeField field : type.getFieldList()) {
                int idx = 0;
                Object fieldName = field.getName();
                while (!names.add((String)fieldName)) {
                    fieldName = field.getName() + idx++;
                }
                builder.add((String)fieldName, field.getType());
            }
        }
        return builder.build();
    }

    public static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields) {
        return TypeUtils.createRowType(typeFactory, fields, "$F");
    }

    private static RelDataType createRowType(IgniteTypeFactory typeFactory, List<RelDataType> fields, String namePreffix) {
        List names = IntStream.range(0, fields.size()).mapToObj(ord -> namePreffix + ord).collect(Collectors.toList());
        return typeFactory.createStructType(fields, names);
    }

    public static BiFunction<Integer, Object, Object> resultTypeConverter(ExecutionContext<?> ectx, RelDataType resultType) {
        assert (resultType.isStruct());
        if (TypeUtils.hasConvertableFields(resultType)) {
            List types = RelOptUtil.getFieldTypeList((RelDataType)resultType);
            Function[] converters = new Function[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                converters[i] = TypeUtils.fieldConverter(ectx, (RelDataType)types.get(i));
            }
            return (idx, r) -> {
                assert (idx >= 0 && idx < converters.length);
                return converters[idx].apply(r);
            };
        }
        return BI_FUNCTION_IDENTITY_SECOND_ARGUMENT;
    }

    private static Function<Object, Object> fieldConverter(ExecutionContext<?> ectx, RelDataType fieldType) {
        Type storageType = ectx.getTypeFactory().getResultClass(fieldType);
        if (TypeUtils.isConvertableType(fieldType)) {
            return v -> TypeUtils.fromInternal(v, storageType);
        }
        return Function.identity();
    }

    public static boolean isConvertableType(RelDataType type) {
        return CONVERTABLE_TYPES.contains(type.getSqlTypeName());
    }

    private static boolean hasConvertableFields(RelDataType resultType) {
        for (RelDataTypeField field : resultType.getFieldList()) {
            if (!TypeUtils.isConvertableType(field.getType())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Object toInternal(@Nullable Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == LocalDate.class) {
            return (int)((LocalDate)val).toEpochDay();
        }
        if (storageType == LocalTime.class) {
            return (int)TimeUnit.NANOSECONDS.toMillis(((LocalTime)val).toNanoOfDay());
        }
        if (storageType == LocalDateTime.class) {
            LocalDateTime dt = (LocalDateTime)val;
            return TimeUnit.SECONDS.toMillis(dt.toEpochSecond(ZoneOffset.UTC)) + TimeUnit.NANOSECONDS.toMillis(dt.getNano());
        }
        if (storageType == Instant.class) {
            Instant timeStamp = (Instant)val;
            return timeStamp.toEpochMilli();
        }
        if (storageType == Duration.class) {
            return TimeUnit.SECONDS.toMillis(((Duration)val).getSeconds()) + TimeUnit.NANOSECONDS.toMillis(((Duration)val).getNano());
        }
        if (storageType == Period.class) {
            return (int)((Period)val).toTotalMonths();
        }
        if (storageType == byte[].class) {
            if (val instanceof String) {
                return new ByteString(((String)val).getBytes(StandardCharsets.UTF_8));
            }
            if (val instanceof byte[]) {
                return new ByteString((byte[])val);
            }
            assert (val instanceof ByteString) : "Expected ByteString but got " + String.valueOf(val) + ", type=" + val.getClass().getTypeName();
            return val;
        }
        if (val instanceof Number && storageType != val.getClass()) {
            Number num = (Number)val;
            return Byte.class.equals((Object)storageType) || Byte.TYPE.equals(storageType) ? (Number)SqlFunctions.toByte((Number)num) : (Number)(Short.class.equals((Object)storageType) || Short.TYPE.equals(storageType) ? (Number)SqlFunctions.toShort((Number)num) : (Number)(Integer.class.equals((Object)storageType) || Integer.TYPE.equals(storageType) ? (Number)SqlFunctions.toInt((Number)num) : (Number)(Long.class.equals((Object)storageType) || Long.TYPE.equals(storageType) ? (Number)SqlFunctions.toLong((Number)num) : (Number)(Float.class.equals((Object)storageType) || Float.TYPE.equals(storageType) ? (Number)Float.valueOf(SqlFunctions.toFloat((Number)num)) : (Number)(Double.class.equals((Object)storageType) || Double.TYPE.equals(storageType) ? (Number)SqlFunctions.toDouble((Number)num) : (Number)(BigDecimal.class.equals((Object)storageType) ? SqlFunctions.toBigDecimal((Number)num) : num))))));
        }
        NativeTypeSpec nativeTypeSpec = NativeTypeSpec.fromClass((Class)((Class)storageType));
        assert (nativeTypeSpec != null) : "No native type spec for type: " + String.valueOf(storageType);
        Object customType = SafeCustomTypeInternalConversion.INSTANCE.tryConvertToInternal(val, nativeTypeSpec);
        return customType != null ? customType : val;
    }

    @Nullable
    public static Object fromInternal(@Nullable Object val, Type storageType) {
        if (val == null) {
            return null;
        }
        if (storageType == LocalDate.class && val instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)val).intValue());
        }
        if (storageType == LocalTime.class && val instanceof Integer) {
            return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((Integer)val).intValue()));
        }
        if (storageType == LocalDateTime.class && val instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)val), ZoneOffset.UTC);
        }
        if (storageType == Instant.class && val instanceof Long) {
            return Instant.ofEpochMilli((Long)val);
        }
        if (storageType == Duration.class && val instanceof Long) {
            return Duration.ofMillis((Long)val);
        }
        if (storageType == Period.class && val instanceof Integer) {
            return Period.of((Integer)val / 12, (Integer)val % 12, 0);
        }
        if (storageType == byte[].class && val instanceof ByteString) {
            return ((ByteString)val).getBytes();
        }
        NativeTypeSpec nativeTypeSpec = NativeTypeSpec.fromClass((Class)((Class)storageType));
        assert (nativeTypeSpec != null) : "No native type spec for type: " + String.valueOf(storageType);
        Object customType = SafeCustomTypeInternalConversion.INSTANCE.tryConvertFromInternal(val, nativeTypeSpec);
        return customType != null ? customType : val;
    }

    public static ColumnType columnType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                return ColumnType.STRING;
            }
            case DATE: {
                return ColumnType.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return ColumnType.TIME;
            }
            case INTEGER: {
                return ColumnType.INT32;
            }
            case TIMESTAMP: {
                return ColumnType.DATETIME;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return ColumnType.TIMESTAMP;
            }
            case BIGINT: {
                return ColumnType.INT64;
            }
            case SMALLINT: {
                return ColumnType.INT16;
            }
            case TINYINT: {
                return ColumnType.INT8;
            }
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
            case DECIMAL: {
                return ColumnType.DECIMAL;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case REAL: 
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case BINARY: 
            case VARBINARY: 
            case ANY: {
                if (type instanceof IgniteCustomType) {
                    IgniteCustomType customType = (IgniteCustomType)type;
                    return customType.spec().columnType();
                }
            }
            case OTHER: {
                return ColumnType.BYTE_ARRAY;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return ColumnType.PERIOD;
            }
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: 
            case INTERVAL_DAY: {
                return ColumnType.DURATION;
            }
            case NULL: {
                return ColumnType.NULL;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(type.getSqlTypeName()));
    }

    public static RelDataType native2relationalType(RelDataTypeFactory factory, NativeType nativeType) {
        switch (nativeType.spec()) {
            case BOOLEAN: {
                return factory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case INT8: {
                return factory.createSqlType(SqlTypeName.TINYINT);
            }
            case INT16: {
                return factory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INT32: {
                return factory.createSqlType(SqlTypeName.INTEGER);
            }
            case INT64: {
                return factory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return factory.createSqlType(SqlTypeName.REAL);
            }
            case DOUBLE: {
                return factory.createSqlType(SqlTypeName.DOUBLE);
            }
            case DECIMAL: {
                assert (nativeType instanceof DecimalNativeType);
                DecimalNativeType decimal = (DecimalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.DECIMAL, decimal.precision(), decimal.scale());
            }
            case UUID: {
                IgniteTypeFactory concreteTypeFactory = (IgniteTypeFactory)factory;
                return concreteTypeFactory.createCustomType("UUID");
            }
            case STRING: {
                assert (nativeType instanceof VarlenNativeType);
                VarlenNativeType varlen = (VarlenNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.VARCHAR, varlen.length());
            }
            case BYTES: {
                assert (nativeType instanceof VarlenNativeType);
                VarlenNativeType varlen = (VarlenNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.VARBINARY, varlen.length());
            }
            case DATE: {
                return factory.createSqlType(SqlTypeName.DATE);
            }
            case TIME: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType time = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIME, time.precision());
            }
            case TIMESTAMP: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType ts = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, ts.precision());
            }
            case DATETIME: {
                assert (nativeType instanceof TemporalNativeType);
                TemporalNativeType dt = (TemporalNativeType)nativeType;
                return factory.createSqlType(SqlTypeName.TIMESTAMP, dt.precision());
            }
        }
        throw new IllegalStateException("Unexpected native type " + String.valueOf(nativeType));
    }

    public static RelDataType native2relationalType(RelDataTypeFactory factory, NativeType nativeType, boolean nullable) {
        return factory.createTypeWithNullability(TypeUtils.native2relationalType(factory, nativeType), nullable);
    }

    public static List<RelDataType> native2relationalTypes(RelDataTypeFactory factory, NativeType ... nativeTypes) {
        return Arrays.stream(nativeTypes).map(t -> TypeUtils.native2relationalType(factory, t)).collect(Collectors.toList());
    }

    public static NativeType columnType2NativeType(ColumnType columnType, int precision, int scale, int length) {
        switch (columnType) {
            case BOOLEAN: {
                return NativeTypes.BOOLEAN;
            }
            case INT8: {
                return NativeTypes.INT8;
            }
            case INT16: {
                return NativeTypes.INT16;
            }
            case INT32: {
                return NativeTypes.INT32;
            }
            case INT64: {
                return NativeTypes.INT64;
            }
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case DECIMAL: {
                return NativeTypes.decimalOf((int)precision, (int)scale);
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: {
                return NativeTypes.time((int)precision);
            }
            case DATETIME: {
                return NativeTypes.datetime((int)precision);
            }
            case TIMESTAMP: {
                return NativeTypes.timestamp((int)precision);
            }
            case UUID: {
                return NativeTypes.UUID;
            }
            case STRING: {
                return NativeTypes.stringOf((int)length);
            }
            case BYTE_ARRAY: {
                return NativeTypes.blobOf((int)length);
            }
        }
        throw new IllegalArgumentException("No NativeType for type: " + String.valueOf(columnType));
    }

    public static boolean needCastInSearchBounds(IgniteTypeFactory typeFactory, RelDataType fromType, RelDataType toType) {
        if (SqlTypeUtil.isCharacter((RelDataType)toType) && SqlTypeUtil.isCharacter((RelDataType)fromType)) {
            return false;
        }
        if (fromType.getPrecedenceList().containsType(toType) && SqlTypeUtil.isIntType((RelDataType)fromType) && SqlTypeUtil.isIntType((RelDataType)toType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)typeFactory, (RelDataType)fromType, (RelDataType)toType)) {
            return false;
        }
        assert (SqlTypeUtil.canCastFrom((RelDataType)toType, (RelDataType)fromType, (boolean)true));
        return true;
    }

    public static boolean customDataTypeNeedCast(IgniteTypeFactory factory, RelDataType fromType, RelDataType toType) {
        IgniteCustomTypeCoercionRules typeCoercionRules = factory.getCustomTypeCoercionRules();
        if (toType instanceof IgniteCustomType) {
            IgniteCustomType to = (IgniteCustomType)toType;
            return typeCoercionRules.needToCast(fromType, to);
        }
        if (fromType instanceof IgniteCustomType) {
            boolean sameType = SqlTypeUtil.equalSansNullability((RelDataType)fromType, (RelDataType)toType);
            return !sameType;
        }
        String message = IgniteStringFormatter.format((String)"Invalid arguments. Expected at least one custom data type but got {} and {}", (Object[])new Object[]{fromType, toType});
        throw new AssertionError((Object)message);
    }

    public static boolean typeFamiliesAreCompatible(RelDataTypeFactory typeFactory, RelDataType toType, RelDataType fromType) {
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)typeFactory, (RelDataType)toType, (RelDataType)fromType)) {
            return true;
        }
        if (fromType.getSqlTypeName() == SqlTypeName.NULL || toType.getSqlTypeName() == SqlTypeName.NULL) {
            return true;
        }
        if (toType.isStruct() && fromType.isStruct()) {
            if (toType.getFieldCount() != fromType.getFieldCount()) {
                return false;
            }
            for (int i = 0; i < toType.getFieldCount(); ++i) {
                RelDataType type2;
                RelDataType type1 = ((RelDataTypeField)toType.getFieldList().get(i)).getType();
                if (TypeUtils.typeFamiliesAreCompatible(typeFactory, type1, type2 = ((RelDataTypeField)fromType.getFieldList().get(i)).getType())) continue;
                return false;
            }
            return true;
        }
        if (fromType instanceof IgniteCustomType && toType instanceof IgniteCustomType) {
            IgniteCustomType fromCustom = (IgniteCustomType)fromType;
            IgniteCustomType toCustom = (IgniteCustomType)toType;
            return Objects.equals(fromCustom.getCustomTypeName(), toCustom.getCustomTypeName());
        }
        if (fromType instanceof IgniteCustomType || toType instanceof IgniteCustomType) {
            return false;
        }
        if (SqlTypeUtil.canAssignFrom((RelDataType)toType, (RelDataType)fromType)) {
            return SqlTypeUtil.canAssignFrom((RelDataType)fromType, (RelDataType)toType);
        }
        return false;
    }

    public static boolean typeFamiliesAreCompatible(RelDataTypeFactory typeFactory, RelDataType ... types) {
        return TypeUtils.typeFamiliesAreCompatible(typeFactory, List.of(types));
    }

    public static boolean typeFamiliesAreCompatible(RelDataTypeFactory typeFactory, List<RelDataType> types) {
        if (types.size() < 2) {
            return true;
        }
        RelDataType firstType = null;
        for (RelDataType type : types) {
            if (firstType == null) {
                if (SqlTypeUtil.isNull((RelDataType)type)) continue;
                firstType = type;
                continue;
            }
            if (TypeUtils.typeFamiliesAreCompatible(typeFactory, firstType, type)) continue;
            return false;
        }
        return true;
    }

    public static RowSchema rowSchemaFromRelTypes(List<RelDataType> types) {
        RowSchema.Builder fieldTypes = RowSchema.builder();
        for (RelDataType relType : types) {
            TypeSpec typeSpec = TypeUtils.convertToTypeSpec(relType);
            fieldTypes.addField(typeSpec);
        }
        return fieldTypes.build();
    }

    private static TypeSpec convertToTypeSpec(RelDataType type) {
        boolean simpleType = type instanceof BasicSqlType;
        boolean nullable = type.isNullable();
        if (type instanceof IgniteCustomType) {
            NativeType nativeType = IgniteTypeFactory.relDataTypeToNative(type);
            return RowSchemaTypes.nativeTypeWithNullability(nativeType, nullable);
        }
        if (SqlTypeName.ANY == type.getSqlTypeName()) {
            return new BaseTypeSpec(null, nullable);
        }
        if (SqlTypeUtil.isNull((RelDataType)type)) {
            return RowSchemaTypes.NULL;
        }
        if (simpleType) {
            NativeType nativeType = IgniteTypeFactory.relDataTypeToNative(type);
            return RowSchemaTypes.nativeTypeWithNullability(nativeType, nullable);
        }
        if (type instanceof IntervalSqlType) {
            IntervalSqlType intervalType = (IntervalSqlType)type;
            boolean yearMonth = intervalType.getIntervalQualifier().isYearMonth();
            if (yearMonth) {
                return RowSchemaTypes.nativeTypeWithNullability(NativeTypes.INT32, nullable);
            }
            return RowSchemaTypes.nativeTypeWithNullability(NativeTypes.INT64, nullable);
        }
        if (SqlTypeUtil.isRow((RelDataType)type)) {
            ArrayList<TypeSpec> fields = new ArrayList<TypeSpec>();
            for (RelDataTypeField field : type.getFieldList()) {
                TypeSpec fieldTypeSpec = TypeUtils.convertToTypeSpec(field.getType());
                fields.add(fieldTypeSpec);
            }
            return new RowType(fields, type.isNullable());
        }
        if (SqlTypeUtil.isMap((RelDataType)type) || SqlTypeUtil.isMultiset((RelDataType)type) || SqlTypeUtil.isArray((RelDataType)type)) {
            throw new IllegalArgumentException("Collection types is not supported: " + String.valueOf(type));
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf(type));
    }

    public static <RowT> RowT validateCharactersOverflowAndTrimIfPossible(RelDataType rowType, RowHandler<RowT> rowHandler, RowT row, Supplier<RowSchema> schema) {
        boolean containCharType = rowType.getFieldList().stream().anyMatch(t -> SqlTypeName.CHAR_TYPES.contains(t.getType().getSqlTypeName()));
        if (!containCharType) {
            return row;
        }
        int colCount = rowType.getFieldList().size();
        RowHandler.RowBuilder<RowT> rowBldr = null;
        for (int i = 0; i < colCount; ++i) {
            RelDataType colType = ((RelDataTypeField)rowType.getFieldList().get(i)).getType();
            Object data = rowHandler.get(i, row);
            if (!SqlTypeName.CHAR_TYPES.contains(colType.getSqlTypeName()) || data == null) {
                if (rowBldr == null) continue;
                rowBldr.addField(data);
                continue;
            }
            assert (data instanceof String);
            String str = (String)data;
            int colPrecision = colType.getPrecision();
            assert (colPrecision != -1);
            if (str.length() > colPrecision) {
                for (int pos = str.length(); pos > colPrecision; --pos) {
                    if (str.charAt(pos - 1) == ' ') continue;
                    throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Value too long for type: " + String.valueOf(colType));
                }
                str = str.substring(0, colPrecision);
                if (rowBldr == null) {
                    rowBldr = TypeUtils.buildPartialRow(rowHandler, schema, i, row);
                }
            }
            if (rowBldr == null) continue;
            rowBldr.addField(str);
        }
        if (rowBldr != null) {
            return rowBldr.build();
        }
        return row;
    }

    private static <RowT> RowHandler.RowBuilder<RowT> buildPartialRow(RowHandler<RowT> rowHandler, Supplier<RowSchema> schema, int endPos, RowT row) {
        RowHandler.RowFactory<RowT> factory = rowHandler.factory(schema.get());
        RowHandler.RowBuilder<RowT> bldr = factory.rowBuilder();
        for (int i = 0; i < endPos; ++i) {
            Object data = rowHandler.get(i, row);
            bldr.addField(data);
        }
        return bldr;
    }

    public static boolean typesRepresentTheSameColumnTypes(RelDataType lhs, RelDataType rhs) {
        if (TypeUtils.isCustomType(lhs) && TypeUtils.isCustomType(rhs) || SqlTypeUtil.isAtomic((RelDataType)lhs) && SqlTypeUtil.isAtomic((RelDataType)rhs)) {
            ColumnType col2;
            ColumnType col1 = TypeUtils.columnType(lhs);
            return col1 == (col2 = TypeUtils.columnType(rhs));
        }
        return false;
    }

    private static boolean isCustomType(RelDataType type) {
        return type instanceof IgniteCustomType;
    }

    private static class SupportedParamClassesHolder {
        static final Set<ColumnType> UNSUPPORTED_COLUMN_TYPES_AS_PARAMETERS = Set.of(ColumnType.PERIOD, ColumnType.DURATION);
        static final Set<Class<?>> SUPPORTED_PARAM_CLASSES = Arrays.stream(ColumnType.values()).filter(t -> !UNSUPPORTED_COLUMN_TYPES_AS_PARAMETERS.contains(t)).map(ColumnType::javaClass).collect(Collectors.toUnmodifiableSet());

        private SupportedParamClassesHolder() {
        }
    }
}

