/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.table.IgniteTables;

public class ClientComputeExecutePartitionedRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteComputeInternal compute, IgniteTables tables, ClusterService cluster, NotificationSender notificationSender) {
        return ClientTableCommon.readTableAsync(in, tables).thenCompose(table -> {
            out.packInt(table.schemaView().lastKnownSchemaVersion());
            int partitionId = in.unpackInt();
            List deploymentUnits = in.unpackDeploymentUnits();
            String jobClassName = in.unpackString();
            JobExecutionOptions options = JobExecutionOptions.builder().priority(in.unpackInt()).maxRetries(in.unpackInt()).build();
            ComputeJobDataHolder args = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller((ClientMessageUnpacker)in);
            CompletableFuture jobExecutionFut = compute.submitPartitionedInternal(table, partitionId, deploymentUnits, jobClassName, options, args, null);
            ClientComputeExecuteRequest.sendResultAndState(jobExecutionFut, notificationSender);
            return jobExecutionFut.thenCompose(execution -> execution.idAsync().thenAccept(jobId -> ClientComputeExecuteRequest.packSubmitResult(out, jobId, execution.node())));
        });
    }
}

