/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class IgniteStringBuilder
implements Serializable {
    private static final String NL = System.getProperty("line.separator");
    private static final long serialVersionUID = 0L;
    private StringBuilder impl;

    public IgniteStringBuilder() {
        this.impl = new StringBuilder(16);
    }

    public IgniteStringBuilder(int cap) {
        this.impl = new StringBuilder(cap);
    }

    public IgniteStringBuilder(String str) {
        this.impl = new StringBuilder(str);
    }

    public IgniteStringBuilder(CharSequence seq) {
        this.impl = new StringBuilder(seq);
    }

    public void setLength(int len) {
        this.impl.setLength(len);
    }

    public StringBuilder impl() {
        assert (this.impl != null);
        return this.impl;
    }

    public int length() {
        return this.impl.length();
    }

    public IgniteStringBuilder app(@Nullable Object obj) {
        this.impl.append(obj);
        return this;
    }

    public IgniteStringBuilder app(String str) {
        this.impl.append(str);
        return this;
    }

    public IgniteStringBuilder app(StringBuffer sb) {
        this.impl.append(sb);
        return this;
    }

    public IgniteStringBuilder app(CharSequence s) {
        this.impl.append(s);
        return this;
    }

    public IgniteStringBuilder app(CharSequence s, int start, int end) {
        this.impl.append(s, start, end);
        return this;
    }

    public IgniteStringBuilder app(char[] str) {
        this.impl.append(str);
        return this;
    }

    public IgniteStringBuilder app(char[] str, int offset, int len) {
        this.impl.append(str, offset, len);
        return this;
    }

    public IgniteStringBuilder app(boolean b) {
        this.impl.append(b);
        return this;
    }

    public IgniteStringBuilder app(char c) {
        this.impl.append(c);
        return this;
    }

    public IgniteStringBuilder app(int i) {
        this.impl.append(i);
        return this;
    }

    public IgniteStringBuilder app(long lng) {
        this.impl.append(lng);
        return this;
    }

    public IgniteStringBuilder app(float f) {
        this.impl.append(f);
        return this;
    }

    public IgniteStringBuilder app(double d) {
        this.impl.append(d);
        return this;
    }

    public IgniteStringBuilder appendCodePoint(int codePoint) {
        this.impl.appendCodePoint(codePoint);
        return this;
    }

    public IgniteStringBuilder del(int start, int end) {
        this.impl.delete(start, end);
        return this;
    }

    public IgniteStringBuilder del(int index) {
        this.impl.deleteCharAt(index);
        return this;
    }

    public IgniteStringBuilder nl() {
        this.impl.append(NL);
        return this;
    }

    public IgniteStringBuilder rep(int start, int end, String str) {
        this.impl.replace(start, end, str);
        return this;
    }

    public IgniteStringBuilder ins(int index, char[] str, int off, int len) {
        this.impl.insert(index, str, off, len);
        return this;
    }

    public IgniteStringBuilder ins(int off, Object obj) {
        return this.ins(off, String.valueOf(obj));
    }

    public IgniteStringBuilder ins(int off, String str) {
        this.impl.insert(off, str);
        return this;
    }

    public IgniteStringBuilder ins(int off, char[] str) {
        this.impl.insert(off, str);
        return this;
    }

    public IgniteStringBuilder ins(int dstOff, CharSequence s) {
        this.impl.insert(dstOff, s);
        return this;
    }

    public IgniteStringBuilder ins(int dstOff, CharSequence s, int start, int end) {
        this.impl.insert(dstOff, s, start, end);
        return this;
    }

    public IgniteStringBuilder ins(int off, boolean b) {
        this.impl.insert(off, b);
        return this;
    }

    public IgniteStringBuilder ins(int off, char c) {
        this.impl.insert(off, c);
        return this;
    }

    public IgniteStringBuilder ins(int off, int i) {
        return this.ins(off, String.valueOf(i));
    }

    public IgniteStringBuilder ins(int off, long l) {
        return this.ins(off, String.valueOf(l));
    }

    public IgniteStringBuilder ins(int off, float f) {
        return this.ins(off, String.valueOf(f));
    }

    public IgniteStringBuilder ins(int off, double d) {
        return this.ins(off, String.valueOf(d));
    }

    public IgniteStringBuilder appendHex(long val) {
        String hex = Long.toHexString(val);
        int len = hex.length();
        for (int i = 0; i < 16 - len; ++i) {
            this.app('0');
        }
        this.app(hex);
        return this;
    }

    public IgniteStringBuilder appendHex(int val) {
        String hex = Integer.toHexString(val);
        int len = hex.length();
        for (int i = 0; i < 8 - len; ++i) {
            this.app('0');
        }
        this.app(hex);
        return this;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.impl);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.impl = (StringBuilder)s.readObject();
    }

    public String toString() {
        return this.impl.toString();
    }
}

