/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.UUID;
import org.apache.ignite.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public abstract class PartitionMeta {
    private static final VarHandle PAGE_COUNT;
    private static final VarHandle META_SNAPSHOT;
    private volatile PartitionMetaSnapshot metaSnapshot;
    private volatile int pageCount;

    protected PartitionMeta(int pageCount) {
        this.pageCount = pageCount;
    }

    protected final void initSnapshot(@Nullable UUID checkpointId) {
        assert (this.metaSnapshot == null) : "Snapshot is already initialized";
        this.metaSnapshot = this.buildSnapshot(checkpointId);
    }

    protected abstract PartitionMetaSnapshot buildSnapshot(@Nullable UUID var1);

    public int pageCount() {
        return this.pageCount;
    }

    public void incrementPageCount(@Nullable UUID checkpointId) {
        this.updateSnapshot(checkpointId);
        PAGE_COUNT.getAndAdd(this, 1);
    }

    public PartitionMetaSnapshot metaSnapshot(@Nullable UUID checkpointId) {
        this.updateSnapshot(checkpointId);
        return this.metaSnapshot;
    }

    protected final void updateSnapshot(@Nullable UUID checkpointId) {
        PartitionMetaSnapshot current = this.metaSnapshot;
        if (current.checkpointId() != checkpointId) {
            META_SNAPSHOT.compareAndSet(this, current, this.buildSnapshot(checkpointId));
        }
    }

    public String toString() {
        return S.toString(PartitionMeta.class, (Object)this);
    }

    public static long partitionMetaPageId(int partId) {
        return PageIdUtils.pageId(partId, (byte)2, 0);
    }

    static {
        try {
            PAGE_COUNT = MethodHandles.lookup().findVarHandle(PartitionMeta.class, "pageCount", Integer.TYPE);
            META_SNAPSHOT = MethodHandles.lookup().findVarHandle(PartitionMeta.class, "metaSnapshot", PartitionMetaSnapshot.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static interface PartitionMetaSnapshot {
        public void writeTo(PartitionMetaIo var1, long var2);

        @Nullable
        public UUID checkpointId();
    }
}

