/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.JobStatus;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.JobStateImpl;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class FailSafeJobExecution
implements CancellableJobExecution<ComputeJobDataHolder> {
    private static final IgniteLogger LOG = Loggers.forClass(FailSafeJobExecution.class);
    private final AtomicReference<Throwable> exception = new AtomicReference<Object>(null);
    private final CompletableFuture<ComputeJobDataHolder> resultFuture;
    private JobState capturedState;
    private final UUID jobId;
    private CancellableJobExecution<ComputeJobDataHolder> runningJobExecution;
    private CompletableFuture<ComputeJobDataHolder> completeHook;

    FailSafeJobExecution(CancellableJobExecution<ComputeJobDataHolder> runningJobExecution, UUID jobId) {
        this.jobId = jobId;
        this.resultFuture = new CompletableFuture();
        this.runningJobExecution = runningJobExecution;
        this.captureState(runningJobExecution);
        this.registerCompleteHook();
    }

    private void captureState(JobExecution<ComputeJobDataHolder> runningJobExecution) {
        runningJobExecution.stateAsync().completeOnTimeout(this.failedState(), 10L, TimeUnit.SECONDS).whenComplete((state, e) -> {
            this.capturedState = state != null ? state : this.failedState();
        });
    }

    private JobState failedState() {
        return JobStateImpl.builder().id(this.jobId).createTime(Instant.now()).status(JobStatus.FAILED).build();
    }

    private void registerCompleteHook() {
        this.completeHook = this.runningJobExecution.resultAsync().whenComplete((res, err) -> {
            if (err == null) {
                this.resultFuture.complete((ComputeJobDataHolder)res);
            } else {
                this.resultFuture.completeExceptionally((Throwable)err);
            }
        });
    }

    void updateJobExecution(CancellableJobExecution<ComputeJobDataHolder> jobExecution) {
        LOG.debug("Updating job execution: {}", new Object[]{jobExecution});
        CancellableJobExecution<ComputeJobDataHolder> previousRunningJobExecution = this.runningJobExecution;
        CompletableFuture<ComputeJobDataHolder> previousCompleteHook = this.completeHook;
        this.runningJobExecution = jobExecution;
        this.registerCompleteHook();
        previousCompleteHook.cancel(true);
        FailSafeJobExecution.cleanRunningJobExecution(previousRunningJobExecution);
    }

    @Nullable
    private JobState transformState(@Nullable JobState jobState) {
        if (jobState == null) {
            return null;
        }
        if (this.capturedState == null) {
            this.capturedState = jobState;
        }
        return JobStateImpl.toBuilder((JobState)jobState).createTime(this.capturedState.createTime()).id(this.jobId).build();
    }

    public CompletableFuture<ComputeJobDataHolder> resultAsync() {
        return this.resultFuture;
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        if (this.exception.get() != null) {
            return CompletableFuture.failedFuture(this.exception.get());
        }
        return this.runningJobExecution.stateAsync().thenApply(this::transformState);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        if (this.exception.get() != null) {
            return CompletableFuture.failedFuture(this.exception.get());
        }
        return this.runningJobExecution.cancelAsync();
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        if (this.exception.get() != null) {
            return CompletableFuture.failedFuture(this.exception.get());
        }
        return this.runningJobExecution.changePriorityAsync(newPriority);
    }

    public ClusterNode node() {
        return this.runningJobExecution.node();
    }

    void completeExceptionally(Exception ex) {
        if (!this.exception.compareAndSet(null, ex)) {
            throw new IllegalStateException("Job is already completed exceptionally.");
        }
        this.resultFuture.completeExceptionally(ex);
        FailSafeJobExecution.cleanRunningJobExecution(this.runningJobExecution);
    }

    private static void cleanRunningJobExecution(CancellableJobExecution<ComputeJobDataHolder> previousRunningJobExecution) {
        previousRunningJobExecution.resultAsync().cancel(true);
    }
}

