/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.rules.ImmutableFilterToCalcRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterToCalcRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterToCalcRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterToCalcRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        RelNode rel = filter.getInput();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelDataType inputRowType = rel.getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(filter.getCondition());
        RexProgram program = programBuilder.getProgram();
        LogicalCalc calc = LogicalCalc.create(rel, program);
        call.transformTo(calc);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterToCalcRule.Config.of().withOperandSupplier(b -> b.operand(LogicalFilter.class).predicate(filter -> !RexUtil.SubQueryFinder.containsSubQuery(filter)).anyInputs());

        @Override
        default public FilterToCalcRule toRule() {
            return new FilterToCalcRule(this);
        }
    }
}

