/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.FinishedReadOnlyTransactionTracker;
import org.apache.ignite.internal.tx.impl.FinishedTransactionBatchRequestHandler;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.metrics.ResourceVacuumMetrics;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class ResourceVacuumManager
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ResourceVacuumManager.class);
    private static final int RESOURCE_VACUUM_EXECUTOR_SIZE = 1;
    public static final String RESOURCE_VACUUM_INTERVAL_MILLISECONDS_PROPERTY = "RESOURCE_VACUUM_INTERVAL_MILLISECONDS";
    private final int resourceVacuumIntervalMilliseconds = IgniteSystemProperties.getInteger((String)"RESOURCE_VACUUM_INTERVAL_MILLISECONDS", (int)30000);
    private final FinishedReadOnlyTransactionTracker finishedReadOnlyTransactionTracker;
    private final FinishedTransactionBatchRequestHandler finishedTransactionBatchRequestHandler;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ScheduledExecutorService resourceVacuumExecutor;
    private final RemotelyTriggeredResourceRegistry resourceRegistry;
    private final ClusterNodeResolver clusterNodeResolver;
    private final TxManager txManager;
    private final FailureProcessor failureProcessor;
    private final ResourceVacuumMetrics resourceVacuumMetrics;
    private final MetricManager metricManager;
    private volatile ScheduledFuture<?> vacuumOperationFuture;
    private volatile ScheduledFuture<?> broadcastClosedTransactionsFuture;

    public ResourceVacuumManager(String nodeName, RemotelyTriggeredResourceRegistry resourceRegistry, TopologyService topologyService, MessagingService messagingService, TransactionInflights transactionInflights, TxManager txManager, LowWatermark lowWatermark, FailureProcessor failureProcessor, MetricManager metricManager) {
        this.resourceRegistry = resourceRegistry;
        this.clusterNodeResolver = topologyService;
        this.resourceVacuumExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"resource-vacuum-executor", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        this.finishedReadOnlyTransactionTracker = new FinishedReadOnlyTransactionTracker(topologyService, messagingService, transactionInflights, failureProcessor);
        this.finishedTransactionBatchRequestHandler = new FinishedTransactionBatchRequestHandler(messagingService, resourceRegistry, lowWatermark, this.resourceVacuumExecutor);
        this.resourceVacuumMetrics = new ResourceVacuumMetrics();
        this.txManager = txManager;
        this.failureProcessor = failureProcessor;
        this.metricManager = metricManager;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (this.resourceVacuumIntervalMilliseconds > 0) {
            this.vacuumOperationFuture = this.resourceVacuumExecutor.scheduleAtFixedRate(this::runVacuumOperations, 0L, this.resourceVacuumIntervalMilliseconds, TimeUnit.MILLISECONDS);
            this.broadcastClosedTransactionsFuture = this.resourceVacuumExecutor.scheduleAtFixedRate(this.finishedReadOnlyTransactionTracker::broadcastClosedTransactions, 0L, this.resourceVacuumIntervalMilliseconds, TimeUnit.MILLISECONDS);
        }
        this.finishedTransactionBatchRequestHandler.start();
        this.metricManager.registerSource((MetricSource)this.resourceVacuumMetrics);
        this.metricManager.enable((MetricSource)this.resourceVacuumMetrics);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.busyLock.block();
        if (this.vacuumOperationFuture != null) {
            this.vacuumOperationFuture.cancel(false);
        }
        if (this.broadcastClosedTransactionsFuture != null) {
            this.broadcastClosedTransactionsFuture.cancel(false);
        }
        this.metricManager.disable((MetricSource)this.resourceVacuumMetrics);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.resourceVacuumExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    private void runVacuumOperations() {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, this::vacuumOrphanTxResources);
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, this::vacuumTxnResources);
    }

    private void vacuumOrphanTxResources() {
        try {
            Set<UUID> remoteHosts = this.resourceRegistry.registeredRemoteHosts();
            for (UUID remoteHostId : remoteHosts) {
                if (this.clusterNodeResolver.getById(remoteHostId) != null) continue;
                this.resourceRegistry.closeByRemoteHostId(remoteHostId);
            }
        }
        catch (Throwable err) {
            this.failureProcessor.process(new FailureContext(err, "Error occurred during the orphan resources closing."));
            throw err;
        }
    }

    private void vacuumTxnResources() {
        try {
            this.txManager.vacuum(this.resourceVacuumMetrics);
        }
        catch (Throwable err) {
            this.failureProcessor.process(new FailureContext(err, "Error occurred during txn resources vacuum."));
            throw err;
        }
    }
}

