/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;

public final class GridDhtTxFinishFuture<K, V>
extends GridCacheCompoundIdentityFuture<IgniteInternalTx>
implements IgniteDiagnosticAware {
    private static final long serialVersionUID = 0L;
    private Span span;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicReferenceFieldUpdater<GridDhtTxFinishFuture, Throwable> ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(GridDhtTxFinishFuture.class, Throwable.class, "err");
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    private final GridCacheSharedContext<K, V> cctx;
    private final IgniteUuid futId;
    @GridToStringExclude
    private final GridDhtTxLocalAdapter tx;
    private final boolean commit;
    @GridToStringExclude
    private volatile Throwable err;
    private final Map<UUID, GridDistributedTxMapping> dhtMap;
    private final Map<UUID, GridDistributedTxMapping> nearMap;

    public GridDhtTxFinishFuture(GridCacheSharedContext<K, V> cctx, GridDhtTxLocalAdapter tx, boolean commit) {
        super(F.identityReducer(tx));
        this.cctx = cctx;
        this.tx = tx;
        this.commit = commit;
        this.dhtMap = tx.dhtMap();
        this.nearMap = tx.nearMap();
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            msgLog = cctx.txFinishMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtTxFinishFuture.class);
        }
    }

    public GridDhtTxLocalAdapter tx() {
        return this.tx;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            f.onNodeLeft();
            return true;
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
        assert (false);
    }

    public void rollbackOnError(Throwable e) {
        assert (e != null);
        if (ERR_UPD.compareAndSet(this, null, e)) {
            this.tx.setRollbackOnly();
            if (X.hasCause(e, NodeStoppingException.class) || this.cctx.kernalContext().failure().nodeStopping()) {
                this.onComplete();
            } else {
                this.finish(false);
            }
        }
    }

    public void onResult(UUID nodeId, GridDhtTxFinishResponse res) {
        if (!this.isDone()) {
            boolean found = false;
            for (IgniteInternalFuture fut : this.futures()) {
                MiniFuture f;
                if (!this.isMini(fut) || (f = (MiniFuture)fut).futureId() != res.miniId()) continue;
                found = true;
                assert (f.node().id().equals(nodeId));
                f.onResult(res);
            }
            if (!found && msgLog.isDebugEnabled()) {
                msgLog.debug("DHT finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + "]");
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("DHT finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + "]");
        }
    }

    @Override
    public boolean onDone(IgniteInternalTx tx, Throwable err) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.span);){
            if (this.initialized() || err != null) {
                Throwable finishErr;
                Throwable e;
                block18: {
                    e = this.err;
                    if (this.tx.onePhaseCommit() && this.tx.state() == TransactionState.COMMITTING) {
                        try {
                            boolean nodeStopping = X.hasCause(err, NodeStoppingException.class);
                            this.tx.tmFinish(err == null, nodeStopping || this.cctx.kernalContext().failure().nodeStopping(), false);
                        }
                        catch (IgniteCheckedException finishErr2) {
                            U.error(log, "Failed to finish tx: " + tx, e);
                            if (e != null) break block18;
                            e = finishErr2;
                        }
                    }
                }
                if (this.commit && e == null) {
                    e = this.tx.commitError();
                }
                Throwable throwable = finishErr = e != null ? e : err;
                if (super.onDone(tx, finishErr)) {
                    TxCounters txCounters;
                    if (finishErr == null) {
                        finishErr = this.tx.commitError();
                    }
                    if (this.tx.syncMode() != CacheWriteSynchronizationMode.PRIMARY_SYNC) {
                        this.tx.sendFinishReply(finishErr);
                    }
                    if (!this.commit && this.shouldApplyCountersOnRollbackError(finishErr) && (txCounters = this.tx.txCounters(false)) != null) {
                        try {
                            this.cctx.tm().txHandler().applyPartitionsUpdatesCounters(txCounters.updateCounters(), true, true);
                        }
                        catch (IgniteCheckedException e0) {
                            throw new IgniteException(e0);
                        }
                    }
                    this.cctx.mvcc().removeFuture(this.futId);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    private boolean shouldApplyCountersOnRollbackError(Throwable e) {
        return !(e instanceof NodeStoppingException);
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private void onComplete() {
        this.onDone(this.tx, this.err);
    }

    public void finish(boolean commit) {
        this.span = this.cctx.kernalContext().tracing().create(SpanType.TX_DHT_FINISH, MTC.span());
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            boolean sync = !F.isEmpty(this.dhtMap) || !F.isEmpty(this.nearMap) ? this.finish(commit, this.dhtMap, this.nearMap) : (!commit && !F.isEmpty(this.tx.lockTransactionNodes()) ? this.rollbackLockTransactions(this.tx.lockTransactionNodes()) : false);
            this.markInitialized();
            if (!sync) {
                this.onComplete();
            }
        }
    }

    private boolean rollbackLockTransactions(Collection<ClusterNode> nodes) {
        boolean sync;
        assert (!F.isEmpty(nodes));
        if (this.tx.onePhaseCommit()) {
            return false;
        }
        boolean bl = sync = this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC;
        if (this.tx.explicitLock()) {
            sync = true;
        }
        boolean res = false;
        int miniId = 0;
        for (ClusterNode n : nodes) {
            assert (!n.isLocal());
            MiniFuture fut = new MiniFuture(++miniId, n);
            this.add(fut);
            GridDhtTxFinishRequest req = new GridDhtTxFinishRequest(this.tx.nearNodeId(), this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), false, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), this.tx.isSystemInvalidate(), sync ? CacheWriteSynchronizationMode.FULL_SYNC : this.tx.syncMode(), this.tx.completedBase(), this.tx.committedVersions(), this.tx.rolledbackVersions(), this.tx.size(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), false, false, this.cctx.tm().txHandler().filterUpdateCountersForBackupNode(this.tx, n));
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, sent request lock tx [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + "]");
                }
                if (sync) {
                    res = true;
                    continue;
                }
                fut.onDone();
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onNodeLeft();
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, failed to send request lock tx [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ", err=" + e + "]");
                }
                fut.onResult(e);
            }
        }
        return res;
    }

    private boolean finish(boolean commit, Map<UUID, GridDistributedTxMapping> dhtMap, Map<UUID, GridDistributedTxMapping> nearMap) {
        boolean sync;
        if (this.tx.onePhaseCommit()) {
            return false;
        }
        boolean bl = sync = this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC;
        if (this.tx.explicitLock()) {
            sync = true;
        }
        boolean res = false;
        int miniId = 0;
        for (GridDistributedTxMapping dhtMapping : dhtMap.values()) {
            ClusterNode n = dhtMapping.primary();
            assert (!n.isLocal());
            GridDistributedTxMapping nearMapping = nearMap.get(n.id());
            if (dhtMapping.empty() && nearMapping != null && nearMapping.empty()) continue;
            MiniFuture fut = new MiniFuture(++miniId, dhtMapping, nearMapping);
            this.add(fut);
            GridDhtTxFinishRequest req = new GridDhtTxFinishRequest(this.tx.nearNodeId(), this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), commit, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), this.tx.isSystemInvalidate(), sync || !commit ? CacheWriteSynchronizationMode.FULL_SYNC : this.tx.syncMode(), this.tx.completedBase(), this.tx.committedVersions(), this.tx.rolledbackVersions(), this.tx.size(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), false, false, commit ? null : this.cctx.tm().txHandler().filterUpdateCountersForBackupNode(this.tx, n));
            try {
                if (Objects.isNull(this.cctx.discovery().getAlive(n.id()))) {
                    log.error("Unable to send message (node left topology): " + n);
                    fut.onNodeLeft();
                    continue;
                }
                this.cctx.tm().sendTransactionMessage(n, (GridCacheMessage)req, (IgniteInternalTx)this.tx, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, sent request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + "]");
                }
                if (sync || !commit) {
                    res = true;
                    continue;
                }
                fut.onDone();
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onNodeLeft();
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, failed to send request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ", err=" + e + "]");
                }
                fut.onResult(e);
            }
        }
        for (GridDistributedTxMapping nearMapping : nearMap.values()) {
            if (dhtMap.containsKey(nearMapping.primary().id()) || nearMapping.empty()) continue;
            MiniFuture fut = new MiniFuture(++miniId, null, nearMapping);
            this.add(fut);
            GridDhtTxFinishRequest req = new GridDhtTxFinishRequest(this.tx.nearNodeId(), this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), commit, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), this.tx.isSystemInvalidate(), sync ? CacheWriteSynchronizationMode.FULL_SYNC : this.tx.syncMode(), this.tx.completedBase(), this.tx.committedVersions(), this.tx.rolledbackVersions(), this.tx.size(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), false, false, null);
            try {
                this.cctx.io().send(nearMapping.primary(), (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, sent request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + "]");
                }
                if (sync) {
                    res = true;
                    continue;
                }
                fut.onDone();
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onNodeLeft();
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, failed to send request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + ", err=" + e + "]");
                }
                fut.onResult(e);
            }
        }
        return res;
    }

    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext ctx) {
        if (!this.isDone()) {
            for (IgniteInternalFuture fut : this.futures()) {
                MiniFuture f;
                if (fut.isDone() || !(fut instanceof MiniFuture) || (f = (MiniFuture)fut).node().isLocal()) continue;
                GridCacheVersion dhtVer = this.tx.xidVersion();
                GridCacheVersion nearVer = this.tx.nearXidVersion();
                ctx.remoteTxInfo(f.node().id(), dhtVer, nearVer, "GridDhtTxFinishFuture waiting for response [node=" + f.node().id() + ", topVer=" + this.tx.topologyVersion() + ", dhtVer=" + dhtVer + ", nearVer=" + nearVer + ", futId=" + this.futId + ", miniId=" + f.futId + ", tx=" + this.tx + "]");
                return;
            }
        }
    }

    @Override
    public String toString() {
        Collection<String> futs = F.viewReadOnly(this.futures(), f -> {
            if (f.getClass() == MiniFuture.class) {
                return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
            }
            return f.toString();
        }, new IgnitePredicate[0]);
        return S.toString(GridDhtTxFinishFuture.class, this, "xidVer", (Object)this.tx.xidVersion(), "innerFuts", futs, "super", (Object)super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private final int futId;
        @GridToStringInclude
        private GridDistributedTxMapping dhtMapping;
        @GridToStringInclude
        private GridDistributedTxMapping nearMapping;
        @GridToStringInclude
        private ClusterNode node;

        private MiniFuture(int futId, ClusterNode node) {
            this.futId = futId;
            this.node = node;
        }

        MiniFuture(int futId, GridDistributedTxMapping dhtMapping, GridDistributedTxMapping nearMapping) {
            assert (dhtMapping == null || nearMapping == null || dhtMapping.primary().equals(nearMapping.primary()));
            this.futId = futId;
            this.dhtMapping = dhtMapping;
            this.nearMapping = nearMapping;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node != null ? this.node : (this.dhtMapping != null ? this.dhtMapping.primary() : this.nearMapping.primary());
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + "]");
            }
            this.onDone(e);
        }

        void onNodeLeft() {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT finish fut, mini future node left [txId=" + GridDhtTxFinishFuture.this.tx.nearXidVersion() + ", dhtTxId=" + GridDhtTxFinishFuture.this.tx.xidVersion() + ", node=" + this.node().id() + "]");
            }
            this.onDone(GridDhtTxFinishFuture.this.tx);
        }

        void onResult(GridDhtTxFinishResponse res) {
            if (log.isDebugEnabled()) {
                log.debug("Transaction synchronously completed on node [node=" + this.node() + ", res=" + res + "]");
            }
            this.onDone();
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", (Object)this.isCancelled(), "err", (Object)this.error());
        }
    }
}

