/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageRowStoreEntry;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorage;

public class MetastorageRowStore {
    private final PartitionMetaStorage<MetastorageRowStoreEntry> partStorage;
    protected final IgniteCacheDatabaseSharedManager db;

    public MetastorageRowStore(PartitionMetaStorage<MetastorageRowStoreEntry> partStorage, IgniteCacheDatabaseSharedManager db) {
        this.partStorage = partStorage;
        this.db = db;
    }

    public byte[] readRow(long link) throws IgniteCheckedException {
        assert (link != 0L);
        return this.partStorage.readRow(link);
    }

    public void removeRow(long link) throws IgniteCheckedException {
        assert (link != 0L);
        this.db.checkpointReadLock();
        try {
            this.partStorage.removeDataRowByLink(link, IoStatisticsHolderNoOp.INSTANCE);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addRow(byte[] val) throws IgniteCheckedException {
        this.db.checkpointReadLock();
        try {
            MetastorageRowStoreEntry row = new MetastorageRowStoreEntry(val);
            this.partStorage.insertDataRow(row, IoStatisticsHolderNoOp.INSTANCE);
            long l = row.link();
            return l;
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }
}

