/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.marshaller;

import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.marshaller.FieldAccessor;
import org.apache.ignite3.internal.marshaller.MarshallerColumn;
import org.apache.ignite3.internal.marshaller.MarshallerReader;
import org.apache.ignite3.internal.marshaller.MarshallerWriter;
import org.apache.ignite3.internal.marshaller.UnmappedColumnsException;
import org.apache.ignite3.internal.util.Factory;
import org.apache.ignite3.internal.util.ObjectFactory;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.OneColumnMapper;
import org.apache.ignite3.table.mapper.PojoMapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.jetbrains.annotations.Nullable;

public abstract class Marshaller {
    static Marshaller createMarshaller(MarshallerColumn[] cols, Mapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        if (mapper.targetType() == Void.class) {
            return new NoOpMarshaller();
        }
        if (mapper.targetType().isPrimitive()) {
            throw new MarshallerException(IgniteStringFormatter.format("Mappers for primitive types are not supported: {}", mapper.targetType()));
        }
        if (mapper instanceof OneColumnMapper) {
            return Marshaller.simpleMarshaller(cols, (OneColumnMapper)mapper);
        }
        if (mapper instanceof PojoMapper) {
            return Marshaller.pojoMarshaller(cols, (PojoMapper)mapper, requireAllFields, allowUnmappedFields);
        }
        throw new MarshallerException(IgniteStringFormatter.format("Mapper of unsupported type: {}", mapper.getClass()));
    }

    private static SimpleMarshaller simpleMarshaller(MarshallerColumn[] cols, OneColumnMapper<?> mapper) {
        MarshallerColumn column = Marshaller.findColumnIndex(cols, mapper.mappedColumn());
        return new SimpleMarshaller(FieldAccessor.createIdentityAccessor(column, column.schemaIndex(), mapper.converter()));
    }

    private static MarshallerColumn findColumnIndex(MarshallerColumn[] cols, @Nullable String name) {
        if (name == null) {
            if (cols.length != 1) {
                throw new MarshallerException(IgniteStringFormatter.format("Failed to map object to a single column: schema contains {} columns but no mapped columns were provided", cols.length));
            }
            return cols[0];
        }
        for (MarshallerColumn column : cols) {
            if (!column.name().equals(name)) continue;
            return column;
        }
        throw new MarshallerException(IgniteStringFormatter.format("Failed to map object to a single column: mappedColumn '{}' is not present in the schema", name));
    }

    private static PojoMarshaller pojoMarshaller(MarshallerColumn[] cols, PojoMapper<?> mapper, boolean requireAllFields, boolean allowUnmappedFields) {
        Collection<String> fields;
        FieldAccessor[] fieldAccessors = new FieldAccessor[cols.length];
        int usedFields = 0;
        for (int i = 0; i < cols.length; ++i) {
            MarshallerColumn col = cols[i];
            String columnName = col.name();
            String fieldName = mapper.fieldForColumn(columnName);
            if (fieldName == null) {
                if (requireAllFields) {
                    throw new MarshallerException(IgniteStringFormatter.format("No mapped object field found for column '{}'", columnName));
                }
                fieldAccessors[i] = FieldAccessor.noopAccessor(col);
                continue;
            }
            ++usedFields;
            TypeConverter converter = mapper.converterForColumn(columnName);
            fieldAccessors[i] = FieldAccessor.create(mapper.targetType(), fieldName, col, i, converter);
        }
        if (!allowUnmappedFields && (fields = mapper.fields()).size() > usedFields) {
            TreeSet<String> fieldSet = new TreeSet<String>(fields);
            for (MarshallerColumn col : cols) {
                String fieldName = mapper.fieldForColumn(col.name());
                if (fieldName == null) {
                    assert (!requireAllFields);
                    continue;
                }
                fieldSet.remove(fieldName);
            }
            throw new MarshallerException(IgniteStringFormatter.format("Fields {} of type {} are not mapped to columns", fieldSet, mapper.targetType().getName()), (Throwable)new UnmappedColumnsException());
        }
        return new PojoMarshaller(new ObjectFactory(mapper.targetType()), fieldAccessors);
    }

    @Nullable
    public abstract Object value(Object var1, int var2);

    public abstract Object readObject(MarshallerReader var1, @Nullable Object var2) throws MarshallerException;

    public abstract void writeObject(@Nullable Object var1, MarshallerWriter var2) throws MarshallerException;

    public abstract void writeField(@Nullable Object var1, MarshallerWriter var2, int var3) throws MarshallerException;

    private static class NoOpMarshaller
    extends Marshaller {
        private NoOpMarshaller() {
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) {
            return null;
        }

        @Override
        public Object readObject(MarshallerReader reader, @Nullable Object target) {
            return null;
        }

        @Override
        public void writeObject(Object obj, MarshallerWriter writer) {
        }

        @Override
        public void writeField(Object obj, MarshallerWriter writer, int fldIdx) throws MarshallerException {
        }
    }

    private static class SimpleMarshaller
    extends Marshaller {
        private final FieldAccessor.IdentityAccessor fieldAccessor;

        SimpleMarshaller(FieldAccessor.IdentityAccessor fieldAccessor) {
            this.fieldAccessor = fieldAccessor;
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) {
            assert (fldIdx == 0);
            return this.fieldAccessor.value(obj);
        }

        @Override
        public Object readObject(MarshallerReader reader, Object target) {
            return this.fieldAccessor.read(reader);
        }

        @Override
        public void writeObject(@Nullable Object obj, MarshallerWriter writer) throws MarshallerException {
            this.fieldAccessor.write(writer, obj);
        }

        @Override
        public void writeField(Object obj, MarshallerWriter writer, int fldIdx) throws MarshallerException {
            assert (fldIdx == 0);
            this.fieldAccessor.write(writer, obj);
        }
    }

    private static class PojoMarshaller
    extends Marshaller {
        private final FieldAccessor[] fieldAccessors;
        private final Factory<?> factory;

        PojoMarshaller(Factory<?> factory, FieldAccessor[] fieldAccessors) {
            this.fieldAccessors = fieldAccessors;
            this.factory = Objects.requireNonNull(factory);
        }

        @Override
        @Nullable
        public Object value(Object obj, int fldIdx) {
            return this.fieldAccessors[fldIdx].value(obj);
        }

        @Override
        public Object readObject(MarshallerReader reader, Object target) throws MarshallerException {
            Object obj = target == null ? this.factory.create() : target;
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                this.fieldAccessors[fldIdx].read(reader, obj);
            }
            return obj;
        }

        @Override
        public void writeObject(@Nullable Object obj, MarshallerWriter writer) throws MarshallerException {
            for (int fldIdx = 0; fldIdx < this.fieldAccessors.length; ++fldIdx) {
                this.fieldAccessors[fldIdx].write(writer, obj);
            }
        }

        @Override
        public void writeField(@Nullable Object obj, MarshallerWriter writer, int fldIdx) throws MarshallerException {
            this.fieldAccessors[fldIdx].write(writer, obj);
        }
    }
}

