/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite3.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.subscription.TransformingPublisher;
import org.apache.ignite3.internal.utils.PrimaryReplica;
import org.jetbrains.annotations.Nullable;

public class ScannableTableImpl
implements ScannableTable {
    private final InternalTable internalTable;
    private final TableRowConverterFactory converterFactory;

    public ScannableTableImpl(InternalTable internalTable, TableRowConverterFactory converterFactory) {
        this.internalTable = internalTable;
        this.converterFactory = converterFactory;
    }

    @Override
    public <RowT> Flow.Publisher<RowT> scan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowHandler.RowFactory<RowT> rowFactory, int @Nullable [] requiredColumns) {
        Flow.Publisher<BinaryRow> pub;
        TxAttributes txAttributes = ctx.txAttributes();
        int partId = partWithConsistencyToken.partId();
        if (txAttributes.readOnly()) {
            HybridTimestamp readTime = txAttributes.time();
            assert (readTime != null);
            pub = this.internalTable.scan(partId, txAttributes.id(), readTime, ctx.localNode(), txAttributes.coordinatorId());
        } else {
            PrimaryReplica recipient = new PrimaryReplica(ctx.localNode(), partWithConsistencyToken.enlistmentConsistencyToken());
            pub = this.internalTable.scan(partId, txAttributes.id(), txAttributes.commitPartition(), txAttributes.coordinatorId(), recipient, null, null, null, 0, null);
        }
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher<BinaryRow, Object>(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexRangeScan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowHandler.RowFactory<RowT> rowFactory, int indexId, List<String> columns, @Nullable RangeCondition<RowT> cond, int @Nullable [] requiredColumns) {
        Flow.Publisher<BinaryRow> pub;
        BinaryTuplePrefix upper;
        BinaryTuplePrefix lower;
        TxAttributes txAttributes = ctx.txAttributes();
        RowHandler<RowT> handler = rowFactory.handler();
        int flags = 0;
        if (cond == null) {
            flags = 3;
            lower = null;
            upper = null;
        } else {
            lower = ScannableTableImpl.toBinaryTuplePrefix(columns.size(), handler, cond.lower());
            upper = ScannableTableImpl.toBinaryTuplePrefix(columns.size(), handler, cond.upper());
            flags |= cond.lowerInclude() ? 1 : 0;
            flags |= cond.upperInclude() ? 2 : 0;
        }
        int partId = partWithConsistencyToken.partId();
        if (txAttributes.readOnly()) {
            HybridTimestamp readTime = txAttributes.time();
            assert (readTime != null);
            pub = this.internalTable.scan(partId, txAttributes.id(), readTime, ctx.localNode(), indexId, lower, upper, flags, null, txAttributes.coordinatorId());
        } else {
            pub = this.internalTable.scan(partId, txAttributes.id(), txAttributes.commitPartition(), txAttributes.coordinatorId(), new PrimaryReplica(ctx.localNode(), partWithConsistencyToken.enlistmentConsistencyToken()), indexId, lower, upper, flags, null);
        }
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher<BinaryRow, Object>(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexLookup(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowHandler.RowFactory<RowT> rowFactory, int indexId, List<String> columns, RowT key, int @Nullable [] requiredColumns) {
        Flow.Publisher<BinaryRow> pub;
        TxAttributes txAttributes = ctx.txAttributes();
        RowHandler<RowT> handler = rowFactory.handler();
        BinaryTuple keyTuple = handler.toBinaryTuple(key);
        assert (keyTuple.elementCount() == columns.size()) : IgniteStringFormatter.format("Key should contain exactly {} fields, but was {}", columns.size(), handler.toString(key));
        int partId = partWithConsistencyToken.partId();
        if (txAttributes.readOnly()) {
            HybridTimestamp readTime = txAttributes.time();
            assert (readTime != null);
            pub = this.internalTable.lookup(partId, txAttributes.id(), readTime, ctx.localNode(), indexId, keyTuple, null, txAttributes.coordinatorId());
        } else {
            pub = this.internalTable.lookup(partId, txAttributes.id(), txAttributes.commitPartition(), txAttributes.coordinatorId(), new PrimaryReplica(ctx.localNode(), partWithConsistencyToken.enlistmentConsistencyToken()), indexId, keyTuple, null);
        }
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher<BinaryRow, Object>(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> CompletableFuture<RowT> primaryKeyLookup(ExecutionContext<RowT> ctx, InternalTransaction tx, RowHandler.RowFactory<RowT> rowFactory, RowT key, int @Nullable [] requiredColumns) {
        assert (tx != null);
        TableRowConverter converter = this.converterFactory.create(requiredColumns);
        BinaryRowEx keyRow = converter.toKeyRow(ctx, key);
        return this.internalTable.get(keyRow, tx).thenApply(tableRow -> {
            if (tableRow == null) {
                return null;
            }
            return converter.toRow(ctx, (BinaryRow)tableRow, rowFactory);
        });
    }

    @Override
    public CompletableFuture<Long> estimatedSize() {
        return this.internalTable.estimatedSize();
    }

    @Nullable
    private static <RowT> BinaryTuplePrefix toBinaryTuplePrefix(int searchBoundSize, RowHandler<RowT> handler, @Nullable RowT prefix) {
        if (prefix == null || handler.columnCount(prefix) == 0) {
            return null;
        }
        assert (searchBoundSize >= handler.columnCount(prefix)) : "Invalid range condition";
        return BinaryTuplePrefix.fromBinaryTuple(searchBoundSize, handler.toBinaryTuple(prefix));
    }
}

