/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping;

import java.util.function.Predicate;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class MappingParameters {
    public static final MappingParameters EMPTY = new MappingParameters(ArrayUtils.OBJECT_EMPTY_ARRAY, false, null);
    public static final MappingParameters MAP_ON_BACKUPS = new MappingParameters(ArrayUtils.OBJECT_EMPTY_ARRAY, true, null);
    private final boolean mapOnBackups;
    private final Object[] dynamicParameters;
    @Nullable
    private final Predicate<String> nodeExclusionFilter;

    public static MappingParameters create(Object[] dynamicParameters, boolean mapOnBackups, @Nullable Predicate<String> nodeExclusionFilter) {
        if (dynamicParameters.length == 0 && nodeExclusionFilter == null) {
            return mapOnBackups ? MAP_ON_BACKUPS : EMPTY;
        }
        return new MappingParameters(dynamicParameters, mapOnBackups, nodeExclusionFilter);
    }

    private MappingParameters(Object[] dynamicParameters, boolean mapOnBackups, @Nullable Predicate<String> nodeExclusionFilter) {
        this.dynamicParameters = dynamicParameters;
        this.mapOnBackups = mapOnBackups;
        this.nodeExclusionFilter = nodeExclusionFilter;
    }

    Object[] dynamicParameters() {
        return this.dynamicParameters;
    }

    boolean mapOnBackups() {
        return this.mapOnBackups;
    }

    @Nullable
    Predicate<String> nodeExclusionFilter() {
        return this.nodeExclusionFilter;
    }
}

