package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.GeospatialDataBoundingBox;
import org.apache.baremaps.ogcapi.model.GeospatialDataDataType;
import org.apache.baremaps.ogcapi.model.GeospatialDataPropertiesSchema;
import org.apache.baremaps.ogcapi.model.GeospatialDataStyle;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("geospatialData")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class GeospatialData   {
  private @Valid String title;
  private @Valid String description;
  private @Valid String keywords;
  private @Valid String id;
  private @Valid GeospatialDataDataType dataType;
  private @Valid Integer geometryDimension;
  private @Valid String featureType;
  private @Valid String attribution;
  private @Valid String license;
  private @Valid String pointOfContact;
  private @Valid String publisher;
  private @Valid String theme;
  private @Valid TileSetCrs crs;
  private @Valid BigDecimal epoch;
  private @Valid BigDecimal minScaleDenominator;
  private @Valid BigDecimal maxScaleDenominator;
  private @Valid BigDecimal minCellSize;
  private @Valid BigDecimal maxCellSize;
  private @Valid String maxTileMatrix;
  private @Valid String minTileMatrix;
  private @Valid GeospatialDataBoundingBox boundingBox;
  private @Valid Object created;
  private @Valid Object updated;
  private @Valid GeospatialDataStyle style;
  private @Valid List<String> geoDataClasses = null;
  private @Valid GeospatialDataPropertiesSchema propertiesSchema;
  private @Valid List<Link> links = null;

  /**
   * Title of this tile matrix set, normally used for display to a human
   **/
  public GeospatialData title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "Title of this tile matrix set, normally used for display to a human")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Brief narrative description of this tile matrix set, normally available for display to a human
   **/
  public GeospatialData description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "Brief narrative description of this tile matrix set, normally available for display to a human")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this layer
   **/
  public GeospatialData keywords(String keywords) {
    this.keywords = keywords;
    return this;
  }

  
  @ApiModelProperty(value = "Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this layer")
  @JsonProperty("keywords")
  public String getKeywords() {
    return keywords;
  }

  @JsonProperty("keywords")
  public void setKeywords(String keywords) {
    this.keywords = keywords;
  }

  /**
   * Unique identifier of the Layer. Implementation of &#39;identifier&#39;
   **/
  public GeospatialData id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Unique identifier of the Layer. Implementation of 'identifier'")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   **/
  public GeospatialData dataType(GeospatialDataDataType dataType) {
    this.dataType = dataType;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("dataType")
  @NotNull
  public GeospatialDataDataType getDataType() {
    return dataType;
  }

  @JsonProperty("dataType")
  public void setDataType(GeospatialDataDataType dataType) {
    this.dataType = dataType;
  }

  /**
   * The geometry dimension of the features shown in this layer (0: points, 1: curves, 2: surfaces, 3: solids), unspecified: mixed or unknown
   * minimum: 0
   * maximum: 3
   **/
  public GeospatialData geometryDimension(Integer geometryDimension) {
    this.geometryDimension = geometryDimension;
    return this;
  }

  
  @ApiModelProperty(value = "The geometry dimension of the features shown in this layer (0: points, 1: curves, 2: surfaces, 3: solids), unspecified: mixed or unknown")
  @JsonProperty("geometryDimension")
 @Min(0) @Max(3)  public Integer getGeometryDimension() {
    return geometryDimension;
  }

  @JsonProperty("geometryDimension")
  public void setGeometryDimension(Integer geometryDimension) {
    this.geometryDimension = geometryDimension;
  }

  /**
   * Feature type identifier. Only applicable to layers of datatype &#39;geometries&#39;
   **/
  public GeospatialData featureType(String featureType) {
    this.featureType = featureType;
    return this;
  }

  
  @ApiModelProperty(value = "Feature type identifier. Only applicable to layers of datatype 'geometries'")
  @JsonProperty("featureType")
  public String getFeatureType() {
    return featureType;
  }

  @JsonProperty("featureType")
  public void setFeatureType(String featureType) {
    this.featureType = featureType;
  }

  /**
   * Short reference to recognize the author or provider
   **/
  public GeospatialData attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  
  @ApiModelProperty(value = "Short reference to recognize the author or provider")
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  @JsonProperty("attribution")
  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  /**
   * License applicable to the tiles
   **/
  public GeospatialData license(String license) {
    this.license = license;
    return this;
  }

  
  @ApiModelProperty(value = "License applicable to the tiles")
  @JsonProperty("license")
  public String getLicense() {
    return license;
  }

  @JsonProperty("license")
  public void setLicense(String license) {
    this.license = license;
  }

  /**
   * Useful information to contact the authors or custodians for the layer (e.g. e-mail address, a physical address,  phone numbers, etc)
   **/
  public GeospatialData pointOfContact(String pointOfContact) {
    this.pointOfContact = pointOfContact;
    return this;
  }

  
  @ApiModelProperty(value = "Useful information to contact the authors or custodians for the layer (e.g. e-mail address, a physical address,  phone numbers, etc)")
  @JsonProperty("pointOfContact")
  public String getPointOfContact() {
    return pointOfContact;
  }

  @JsonProperty("pointOfContact")
  public void setPointOfContact(String pointOfContact) {
    this.pointOfContact = pointOfContact;
  }

  /**
   * Organization or individual responsible for making the layer available
   **/
  public GeospatialData publisher(String publisher) {
    this.publisher = publisher;
    return this;
  }

  
  @ApiModelProperty(value = "Organization or individual responsible for making the layer available")
  @JsonProperty("publisher")
  public String getPublisher() {
    return publisher;
  }

  @JsonProperty("publisher")
  public void setPublisher(String publisher) {
    this.publisher = publisher;
  }

  /**
   * Category where the layer can be grouped
   **/
  public GeospatialData theme(String theme) {
    this.theme = theme;
    return this;
  }

  
  @ApiModelProperty(value = "Category where the layer can be grouped")
  @JsonProperty("theme")
  public String getTheme() {
    return theme;
  }

  @JsonProperty("theme")
  public void setTheme(String theme) {
    this.theme = theme;
  }

  /**
   **/
  public GeospatialData crs(TileSetCrs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("crs")
  public TileSetCrs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(TileSetCrs crs) {
    this.crs = crs;
  }

  /**
   * Epoch of the Coordinate Reference System (CRS)
   **/
  public GeospatialData epoch(BigDecimal epoch) {
    this.epoch = epoch;
    return this;
  }

  
  @ApiModelProperty(value = "Epoch of the Coordinate Reference System (CRS)")
  @JsonProperty("epoch")
  public BigDecimal getEpoch() {
    return epoch;
  }

  @JsonProperty("epoch")
  public void setEpoch(BigDecimal epoch) {
    this.epoch = epoch;
  }

  /**
   * Minimum scale denominator for usage of the layer
   **/
  public GeospatialData minScaleDenominator(BigDecimal minScaleDenominator) {
    this.minScaleDenominator = minScaleDenominator;
    return this;
  }

  
  @ApiModelProperty(value = "Minimum scale denominator for usage of the layer")
  @JsonProperty("minScaleDenominator")
  public BigDecimal getMinScaleDenominator() {
    return minScaleDenominator;
  }

  @JsonProperty("minScaleDenominator")
  public void setMinScaleDenominator(BigDecimal minScaleDenominator) {
    this.minScaleDenominator = minScaleDenominator;
  }

  /**
   * Maximum scale denominator for usage of the layer
   **/
  public GeospatialData maxScaleDenominator(BigDecimal maxScaleDenominator) {
    this.maxScaleDenominator = maxScaleDenominator;
    return this;
  }

  
  @ApiModelProperty(value = "Maximum scale denominator for usage of the layer")
  @JsonProperty("maxScaleDenominator")
  public BigDecimal getMaxScaleDenominator() {
    return maxScaleDenominator;
  }

  @JsonProperty("maxScaleDenominator")
  public void setMaxScaleDenominator(BigDecimal maxScaleDenominator) {
    this.maxScaleDenominator = maxScaleDenominator;
  }

  /**
   * Minimum cell size for usage of the layer
   **/
  public GeospatialData minCellSize(BigDecimal minCellSize) {
    this.minCellSize = minCellSize;
    return this;
  }

  
  @ApiModelProperty(value = "Minimum cell size for usage of the layer")
  @JsonProperty("minCellSize")
  public BigDecimal getMinCellSize() {
    return minCellSize;
  }

  @JsonProperty("minCellSize")
  public void setMinCellSize(BigDecimal minCellSize) {
    this.minCellSize = minCellSize;
  }

  /**
   * Maximum cell size for usage of the layer
   **/
  public GeospatialData maxCellSize(BigDecimal maxCellSize) {
    this.maxCellSize = maxCellSize;
    return this;
  }

  
  @ApiModelProperty(value = "Maximum cell size for usage of the layer")
  @JsonProperty("maxCellSize")
  public BigDecimal getMaxCellSize() {
    return maxCellSize;
  }

  @JsonProperty("maxCellSize")
  public void setMaxCellSize(BigDecimal maxCellSize) {
    this.maxCellSize = maxCellSize;
  }

  /**
   * TileMatrix identifier associated with the minScaleDenominator
   **/
  public GeospatialData maxTileMatrix(String maxTileMatrix) {
    this.maxTileMatrix = maxTileMatrix;
    return this;
  }

  
  @ApiModelProperty(value = "TileMatrix identifier associated with the minScaleDenominator")
  @JsonProperty("maxTileMatrix")
  public String getMaxTileMatrix() {
    return maxTileMatrix;
  }

  @JsonProperty("maxTileMatrix")
  public void setMaxTileMatrix(String maxTileMatrix) {
    this.maxTileMatrix = maxTileMatrix;
  }

  /**
   * TileMatrix identifier associated with the maxScaleDenominator
   **/
  public GeospatialData minTileMatrix(String minTileMatrix) {
    this.minTileMatrix = minTileMatrix;
    return this;
  }

  
  @ApiModelProperty(value = "TileMatrix identifier associated with the maxScaleDenominator")
  @JsonProperty("minTileMatrix")
  public String getMinTileMatrix() {
    return minTileMatrix;
  }

  @JsonProperty("minTileMatrix")
  public void setMinTileMatrix(String minTileMatrix) {
    this.minTileMatrix = minTileMatrix;
  }

  /**
   **/
  public GeospatialData boundingBox(GeospatialDataBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("boundingBox")
  public GeospatialDataBoundingBox getBoundingBox() {
    return boundingBox;
  }

  @JsonProperty("boundingBox")
  public void setBoundingBox(GeospatialDataBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
  }

  /**
   **/
  public GeospatialData created(Object created) {
    this.created = created;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created")
  public Object getCreated() {
    return created;
  }

  @JsonProperty("created")
  public void setCreated(Object created) {
    this.created = created;
  }

  /**
   **/
  public GeospatialData updated(Object updated) {
    this.updated = updated;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated")
  public Object getUpdated() {
    return updated;
  }

  @JsonProperty("updated")
  public void setUpdated(Object updated) {
    this.updated = updated;
  }

  /**
   **/
  public GeospatialData style(GeospatialDataStyle style) {
    this.style = style;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("style")
  public GeospatialDataStyle getStyle() {
    return style;
  }

  @JsonProperty("style")
  public void setStyle(GeospatialDataStyle style) {
    this.style = style;
  }

  /**
   * URI identifying a class of data contained in this layer (useful to determine compatibility with styles or processes)
   **/
  public GeospatialData geoDataClasses(List<String> geoDataClasses) {
    this.geoDataClasses = geoDataClasses;
    return this;
  }

  
  @ApiModelProperty(value = "URI identifying a class of data contained in this layer (useful to determine compatibility with styles or processes)")
  @JsonProperty("geoDataClasses")
  public List<String> getGeoDataClasses() {
    return geoDataClasses;
  }

  @JsonProperty("geoDataClasses")
  public void setGeoDataClasses(List<String> geoDataClasses) {
    this.geoDataClasses = geoDataClasses;
  }

  public GeospatialData addGeoDataClassesItem(String geoDataClassesItem) {
    if (this.geoDataClasses == null) {
      this.geoDataClasses = new ArrayList<>();
    }

    this.geoDataClasses.add(geoDataClassesItem);
    return this;
  }

  public GeospatialData removeGeoDataClassesItem(String geoDataClassesItem) {
    if (geoDataClassesItem != null && this.geoDataClasses != null) {
      this.geoDataClasses.remove(geoDataClassesItem);
    }

    return this;
  }
  /**
   **/
  public GeospatialData propertiesSchema(GeospatialDataPropertiesSchema propertiesSchema) {
    this.propertiesSchema = propertiesSchema;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("propertiesSchema")
  public GeospatialDataPropertiesSchema getPropertiesSchema() {
    return propertiesSchema;
  }

  @JsonProperty("propertiesSchema")
  public void setPropertiesSchema(GeospatialDataPropertiesSchema propertiesSchema) {
    this.propertiesSchema = propertiesSchema;
  }

  /**
   * Links related to this layer. Possible link &#39;rel&#39; values are: &#39;geodata&#39; for a URL pointing to the collection of geospatial data.
   **/
  public GeospatialData links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "Links related to this layer. Possible link 'rel' values are: 'geodata' for a URL pointing to the collection of geospatial data.")
  @JsonProperty("links")
 @Size(min=1)  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public GeospatialData addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public GeospatialData removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeospatialData geospatialData = (GeospatialData) o;
    return Objects.equals(this.title, geospatialData.title) &&
        Objects.equals(this.description, geospatialData.description) &&
        Objects.equals(this.keywords, geospatialData.keywords) &&
        Objects.equals(this.id, geospatialData.id) &&
        Objects.equals(this.dataType, geospatialData.dataType) &&
        Objects.equals(this.geometryDimension, geospatialData.geometryDimension) &&
        Objects.equals(this.featureType, geospatialData.featureType) &&
        Objects.equals(this.attribution, geospatialData.attribution) &&
        Objects.equals(this.license, geospatialData.license) &&
        Objects.equals(this.pointOfContact, geospatialData.pointOfContact) &&
        Objects.equals(this.publisher, geospatialData.publisher) &&
        Objects.equals(this.theme, geospatialData.theme) &&
        Objects.equals(this.crs, geospatialData.crs) &&
        Objects.equals(this.epoch, geospatialData.epoch) &&
        Objects.equals(this.minScaleDenominator, geospatialData.minScaleDenominator) &&
        Objects.equals(this.maxScaleDenominator, geospatialData.maxScaleDenominator) &&
        Objects.equals(this.minCellSize, geospatialData.minCellSize) &&
        Objects.equals(this.maxCellSize, geospatialData.maxCellSize) &&
        Objects.equals(this.maxTileMatrix, geospatialData.maxTileMatrix) &&
        Objects.equals(this.minTileMatrix, geospatialData.minTileMatrix) &&
        Objects.equals(this.boundingBox, geospatialData.boundingBox) &&
        Objects.equals(this.created, geospatialData.created) &&
        Objects.equals(this.updated, geospatialData.updated) &&
        Objects.equals(this.style, geospatialData.style) &&
        Objects.equals(this.geoDataClasses, geospatialData.geoDataClasses) &&
        Objects.equals(this.propertiesSchema, geospatialData.propertiesSchema) &&
        Objects.equals(this.links, geospatialData.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, description, keywords, id, dataType, geometryDimension, featureType, attribution, license, pointOfContact, publisher, theme, crs, epoch, minScaleDenominator, maxScaleDenominator, minCellSize, maxCellSize, maxTileMatrix, minTileMatrix, boundingBox, created, updated, style, geoDataClasses, propertiesSchema, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeospatialData {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    geometryDimension: ").append(toIndentedString(geometryDimension)).append("\n");
    sb.append("    featureType: ").append(toIndentedString(featureType)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    license: ").append(toIndentedString(license)).append("\n");
    sb.append("    pointOfContact: ").append(toIndentedString(pointOfContact)).append("\n");
    sb.append("    publisher: ").append(toIndentedString(publisher)).append("\n");
    sb.append("    theme: ").append(toIndentedString(theme)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    epoch: ").append(toIndentedString(epoch)).append("\n");
    sb.append("    minScaleDenominator: ").append(toIndentedString(minScaleDenominator)).append("\n");
    sb.append("    maxScaleDenominator: ").append(toIndentedString(maxScaleDenominator)).append("\n");
    sb.append("    minCellSize: ").append(toIndentedString(minCellSize)).append("\n");
    sb.append("    maxCellSize: ").append(toIndentedString(maxCellSize)).append("\n");
    sb.append("    maxTileMatrix: ").append(toIndentedString(maxTileMatrix)).append("\n");
    sb.append("    minTileMatrix: ").append(toIndentedString(minTileMatrix)).append("\n");
    sb.append("    boundingBox: ").append(toIndentedString(boundingBox)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    updated: ").append(toIndentedString(updated)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    geoDataClasses: ").append(toIndentedString(geoDataClasses)).append("\n");
    sb.append("    propertiesSchema: ").append(toIndentedString(propertiesSchema)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

