/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.query.TsFileInsertionQueryDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.scan.TsFileInsertionScanDataContainer;
import org.apache.iotdb.db.pipe.metric.overview.PipeTsFileToTabletsMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;

public class TsFileInsertionDataContainerProvider {
    private final String pipeName;
    private final long creationTime;
    private final File tsFile;
    private final PipePattern pattern;
    private final long startTime;
    private final long endTime;
    protected final PipeTaskMeta pipeTaskMeta;
    protected final PipeTsFileInsertionEvent sourceEvent;

    public TsFileInsertionDataContainerProvider(String pipeName, long creationTime, File tsFile, PipePattern pipePattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, PipeTsFileInsertionEvent sourceEvent) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.tsFile = tsFile;
        this.pattern = pipePattern;
        this.startTime = startTime;
        this.endTime = endTime;
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
    }

    public TsFileInsertionDataContainer provide() throws IOException {
        if (this.pipeName != null) {
            PipeTsFileToTabletsMetrics.getInstance().markTsFileToTabletInvocation(this.pipeName + "_" + this.creationTime);
        }
        double d = PipeDataNodeResourceManager.memory().getUsedMemorySizeInBytes();
        PipeDataNodeResourceManager.memory();
        if (d / (double)PipeMemoryManager.getTotalNonFloatingMemorySizeInBytes() > (double)0.7f) {
            return new TsFileInsertionScanDataContainer(this.pipeName, this.creationTime, this.tsFile, this.pattern, this.startTime, this.endTime, this.pipeTaskMeta, this.sourceEvent);
        }
        if (this.pattern instanceof IoTDBPipePattern && !((IoTDBPipePattern)this.pattern).mayMatchMultipleTimeSeriesInOneDevice()) {
            return new TsFileInsertionQueryDataContainer(this.pipeName, this.creationTime, this.tsFile, this.pattern, this.startTime, this.endTime, this.pipeTaskMeta, this.sourceEvent);
        }
        Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(this.tsFile, false);
        if (Objects.isNull(deviceIsAlignedMap)) {
            return new TsFileInsertionScanDataContainer(this.pipeName, this.creationTime, this.tsFile, this.pattern, this.startTime, this.endTime, this.pipeTaskMeta, this.sourceEvent);
        }
        int originalSize = deviceIsAlignedMap.size();
        Map<IDeviceID, Boolean> filteredDeviceIsAlignedMap = this.filterDeviceIsAlignedMapByPattern(deviceIsAlignedMap);
        return (double)filteredDeviceIsAlignedMap.size() / (double)originalSize > PipeConfig.getInstance().getPipeTsFileScanParsingThreshold() ? new TsFileInsertionScanDataContainer(this.pipeName, this.creationTime, this.tsFile, this.pattern, this.startTime, this.endTime, this.pipeTaskMeta, this.sourceEvent) : new TsFileInsertionQueryDataContainer(this.pipeName, this.creationTime, this.tsFile, this.pattern, this.startTime, this.endTime, this.pipeTaskMeta, this.sourceEvent, filteredDeviceIsAlignedMap);
    }

    private Map<IDeviceID, Boolean> filterDeviceIsAlignedMapByPattern(Map<IDeviceID, Boolean> deviceIsAlignedMap) {
        if (Objects.isNull(this.pattern) || this.pattern.isRoot()) {
            return deviceIsAlignedMap;
        }
        return deviceIsAlignedMap.entrySet().stream().filter(entry -> {
            String deviceId = ((PlainDeviceID)entry.getKey()).toStringID();
            return this.pattern.coversDevice(deviceId) || this.pattern.mayOverlapWithDevice(deviceId);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

