/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.resource.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeSnapshotResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSnapshotResourceManager.class);
    public static final String PIPE_SNAPSHOT_DIR_NAME = "pipe_snapshot";
    private final Set<String> pipeCopiedSnapshotDirs;
    private final Map<String, AtomicLong> copiedSnapshotPath2ReferenceCountMap = new HashMap<String, AtomicLong>();
    private final ReentrantLock lock = new ReentrantLock();

    protected PipeSnapshotResourceManager(Set<String> pipeCopiedSnapshotDirs) {
        this.pipeCopiedSnapshotDirs = pipeCopiedSnapshotDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String increaseSnapshotReference(String snapshotPath) throws IOException {
        this.lock.lock();
        try {
            if (this.increaseReferenceIfExists(snapshotPath)) {
                String string = snapshotPath;
                return string;
            }
            String copiedFilePath = this.getCopiedSnapshotPathInPipeDir(snapshotPath);
            if (this.increaseReferenceIfExists(copiedFilePath)) {
                String string = copiedFilePath;
                return string;
            }
            RetryUtils.retryOnException(() -> {
                FileUtils.copyFile(new File(snapshotPath), new File(copiedFilePath));
                return null;
            });
            this.copiedSnapshotPath2ReferenceCountMap.put(copiedFilePath, new AtomicLong(1L));
            String string = copiedFilePath;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean increaseReferenceIfExists(String copiedSnapshotPath) {
        AtomicLong referenceCount = this.copiedSnapshotPath2ReferenceCountMap.get(copiedSnapshotPath);
        if (referenceCount != null) {
            referenceCount.incrementAndGet();
            return true;
        }
        return false;
    }

    private String getCopiedSnapshotPathInPipeDir(String snapshotPath) throws IOException {
        File parentFile = new File(snapshotPath);
        while (!this.pipeCopiedSnapshotDirs.contains(parentFile.getName())) {
            if (parentFile.getParentFile() == null) {
                LOGGER.warn("Cannot find correct target snapshot path in pipe dir for {}", (Object)snapshotPath);
                throw new IOException("Cannot find correct target snapshot path in pipe dir for " + snapshotPath);
            }
            parentFile = parentFile.getParentFile();
        }
        return parentFile.getPath() + File.separator + PIPE_SNAPSHOT_DIR_NAME + snapshotPath.replace(parentFile.getPath(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseSnapshotReference(String snapshotPath) {
        this.lock.lock();
        try {
            AtomicLong referenceCount = this.copiedSnapshotPath2ReferenceCountMap.get(snapshotPath);
            if (referenceCount == null) {
                return;
            }
            long count = referenceCount.decrementAndGet();
            if (count == 0L) {
                this.copiedSnapshotPath2ReferenceCountMap.remove(snapshotPath);
                FileUtils.deleteFileOrDirectoryWithRetry(new File(snapshotPath));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSnapshotReferenceCount(String snapshotPath) {
        this.lock.lock();
        try {
            AtomicLong count = this.copiedSnapshotPath2ReferenceCountMap.get(snapshotPath);
            long l = count != null ? count.get() : 0L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

