/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.tsfile.utils.Pair;

public class PipeTreeStatementToBatchVisitor
extends StatementVisitor<Optional<Statement>, Void> {
    private static final int MAX_SCHEMA_BATCH_SIZE = PipeConfig.getInstance().getPipeSnapshotExecutionMaxBatchSize();
    private final List<CreateTimeSeriesStatement> createTimeSeriesStatements = new ArrayList<CreateTimeSeriesStatement>();
    private final List<CreateAlignedTimeSeriesStatement> createAlignedTimeSeriesStatements = new ArrayList<CreateAlignedTimeSeriesStatement>();
    private final List<ActivateTemplateStatement> activateTemplateStatements = new ArrayList<ActivateTemplateStatement>();

    @Override
    public Optional<Statement> visitNode(StatementNode statement, Void context) {
        return Optional.of((Statement)statement);
    }

    @Override
    public Optional<Statement> visitCreateTimeseries(CreateTimeSeriesStatement statement, Void context) {
        this.createTimeSeriesStatements.add(statement);
        return this.createTimeSeriesStatements.size() + this.createAlignedTimeSeriesStatements.size() >= MAX_SCHEMA_BATCH_SIZE ? Optional.of(this.getTimeSeriesBatchStatement()) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement statement, Void context) {
        this.createAlignedTimeSeriesStatements.add(statement);
        return this.createTimeSeriesStatements.size() + this.createAlignedTimeSeriesStatements.size() >= MAX_SCHEMA_BATCH_SIZE ? Optional.of(this.getTimeSeriesBatchStatement()) : Optional.empty();
    }

    private InternalCreateMultiTimeSeriesStatement getTimeSeriesBatchStatement() {
        InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement = new InternalCreateMultiTimeSeriesStatement(new HashMap<PartialPath, Pair<Boolean, MeasurementGroup>>());
        this.createTimeSeriesStatements.forEach(statement -> this.addNonAlignedTimeSeriesToBatchStatement((CreateTimeSeriesStatement)statement, internalCreateMultiTimeSeriesStatement));
        this.createAlignedTimeSeriesStatements.forEach(statement -> this.addAlignedTimeSeriesToBatchStatement((CreateAlignedTimeSeriesStatement)statement, internalCreateMultiTimeSeriesStatement));
        this.createTimeSeriesStatements.clear();
        this.createAlignedTimeSeriesStatements.clear();
        return internalCreateMultiTimeSeriesStatement;
    }

    private void addNonAlignedTimeSeriesToBatchStatement(CreateTimeSeriesStatement statement, InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement) {
        MeasurementGroup group = (MeasurementGroup)internalCreateMultiTimeSeriesStatement.getDeviceMap().computeIfAbsent(statement.getPath().getDevicePath(), devicePath -> new Pair((Object)false, (Object)new MeasurementGroup())).getRight();
        if (group.addMeasurement(statement.getPath().getMeasurement(), statement.getDataType(), statement.getEncoding(), statement.getCompressor())) {
            group.addAttributes(statement.getAttributes());
            group.addTags(statement.getTags());
            group.addProps(statement.getProps());
            group.addAlias(statement.getAlias());
        }
    }

    private void addAlignedTimeSeriesToBatchStatement(CreateAlignedTimeSeriesStatement statement, InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement) {
        MeasurementGroup group = (MeasurementGroup)internalCreateMultiTimeSeriesStatement.getDeviceMap().computeIfAbsent(statement.getDevicePath(), devicePath -> new Pair((Object)true, (Object)new MeasurementGroup())).getRight();
        for (int i = 0; i < statement.getMeasurements().size(); ++i) {
            if (!group.addMeasurement(statement.getMeasurements().get(i), statement.getDataTypes().get(i), statement.getEncodings().get(i), statement.getCompressors().get(i))) continue;
            group.addProps(new HashMap<String, String>());
            group.addTags(statement.getTagsList().get(i));
            group.addAttributes(statement.getAttributesList().get(i));
            group.addAlias(statement.getAliasList().get(i));
        }
    }

    @Override
    public Optional<Statement> visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, Void context) {
        this.activateTemplateStatements.add(activateTemplateStatement);
        return this.activateTemplateStatements.size() >= MAX_SCHEMA_BATCH_SIZE ? Optional.of(this.getTemplateBatchStatement()) : Optional.empty();
    }

    private BatchActivateTemplateStatement getTemplateBatchStatement() {
        BatchActivateTemplateStatement batchActivateTemplateStatement = new BatchActivateTemplateStatement(this.activateTemplateStatements.stream().map(ActivateTemplateStatement::getPath).collect(Collectors.toList()));
        this.activateTemplateStatements.clear();
        return batchActivateTemplateStatement;
    }

    public List<Optional<Statement>> getRemainBatches() {
        return Arrays.asList(!this.createTimeSeriesStatements.isEmpty() || !this.createAlignedTimeSeriesStatements.isEmpty() ? Optional.of(this.getTimeSeriesBatchStatement()) : Optional.empty(), !this.activateTemplateStatements.isEmpty() ? Optional.of(this.getTemplateBatchStatement()) : Optional.empty());
    }

    public void clear() {
        this.createTimeSeriesStatements.clear();
        this.createAlignedTimeSeriesStatements.clear();
        this.activateTemplateStatements.clear();
    }
}

