/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.ExtendedPartialPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.DeviceFilterUtil;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DevicePredicateFilter;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.table.DataNodeTreeViewSchemaUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableDeviceQuerySource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final TsTable table;
    private final int tagIndex;
    private final List<List<SchemaFilter>> tagDeterminedPredicateList;
    private final List<ColumnHeader> columnHeaderList;
    private final List<TsTableColumnSchema> columnSchemaList;
    private final DevicePredicateFilter filter;
    @Nonnull
    private final List<PartialPath> devicePatternList;
    private final boolean needAligned;

    public TableDeviceQuerySource(String database, TsTable table, List<List<SchemaFilter>> tagDeterminedPredicateList, List<ColumnHeader> columnHeaderList, List<TsTableColumnSchema> columnSchemaList, DevicePredicateFilter filter, boolean needAligned) {
        this.tagIndex = !needAligned && !TreeViewSchema.isTreeViewTable((TsTable)table) ? 3 : DataNodeTreeViewSchemaUtils.getPatternNodes(table).length;
        this.table = table;
        this.tagDeterminedPredicateList = tagDeterminedPredicateList;
        this.columnHeaderList = columnHeaderList;
        this.columnSchemaList = columnSchemaList;
        this.filter = filter;
        this.devicePatternList = TableDeviceQuerySource.getDevicePatternList(database, table, tagDeterminedPredicateList);
        this.needAligned = needAligned;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(final ISchemaRegion schemaRegion) {
        return new ISchemaReader<IDeviceSchemaInfo>(){
            private ISchemaReader<IDeviceSchemaInfo> deviceReader;
            private Throwable throwable;
            private int index = 0;
            private IDeviceSchemaInfo next;

            @Override
            public boolean isSuccess() {
                return this.throwable == null && (this.deviceReader == null || this.deviceReader.isSuccess());
            }

            @Override
            public Throwable getFailure() {
                if (this.throwable != null) {
                    return this.throwable;
                }
                if (this.deviceReader != null) {
                    return this.deviceReader.getFailure();
                }
                return null;
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                if (Objects.nonNull(this.next)) {
                    return true;
                }
                if (Objects.isNull(TableDeviceQuerySource.this.filter)) {
                    while (this.innerHasNext()) {
                        IDeviceSchemaInfo device = this.deviceReader.next();
                        if (device.isAligned() == null) continue;
                        this.next = device;
                        return true;
                    }
                    return false;
                }
                if (TableDeviceQuerySource.this.filter.hasNext()) {
                    this.next = TableDeviceQuerySource.this.filter.next();
                    return true;
                }
                while (this.innerHasNext() && !TableDeviceQuerySource.this.filter.hasNext()) {
                    IDeviceSchemaInfo device = this.deviceReader.next();
                    if (device.isAligned() == null) continue;
                    TableDeviceQuerySource.this.filter.addBatch(device);
                }
                if (!TableDeviceQuerySource.this.filter.hasNext()) {
                    TableDeviceQuerySource.this.filter.prepareBatchResult();
                }
                if (TableDeviceQuerySource.this.filter.hasNext()) {
                    this.next = TableDeviceQuerySource.this.filter.next();
                    return true;
                }
                return false;
            }

            private boolean innerHasNext() {
                try {
                    if (this.throwable != null) {
                        return false;
                    }
                    if (this.deviceReader != null) {
                        if (this.deviceReader.hasNext()) {
                            return true;
                        }
                        this.deviceReader.close();
                        if (!this.deviceReader.isSuccess()) {
                            this.throwable = this.deviceReader.getFailure();
                            return false;
                        }
                    }
                    while (this.index < TableDeviceQuerySource.this.devicePatternList.size()) {
                        this.deviceReader = schemaRegion.getTableDeviceReader((PartialPath)TableDeviceQuerySource.this.devicePatternList.get(this.index));
                        ++this.index;
                        if (this.deviceReader.hasNext()) {
                            return true;
                        }
                        this.deviceReader.close();
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new SchemaExecutionException(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public IDeviceSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IDeviceSchemaInfo result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void close() throws Exception {
                if (Objects.nonNull(this.deviceReader)) {
                    this.deviceReader.close();
                }
                if (Objects.nonNull(TableDeviceQuerySource.this.filter)) {
                    TableDeviceQuerySource.this.filter.close();
                }
            }
        };
    }

    @Nonnull
    public static List<PartialPath> getDevicePatternList(String database, TsTable table, List<List<SchemaFilter>> tagDeterminedPredicateList) {
        String[] stringArray;
        String tableName = table.getTableName();
        if (!TreeViewSchema.isTreeViewTable((TsTable)table)) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "root";
            stringArray2[1] = database;
            stringArray = stringArray2;
            stringArray2[2] = tableName;
        } else {
            stringArray = DataNodeTreeViewSchemaUtils.getPatternNodes(table);
        }
        return DeviceFilterUtil.convertToDevicePattern((String[])stringArray, (int)DataNodeTableCache.getInstance().getTable(database, tableName).getTagNum(), tagDeterminedPredicateList, (boolean)TreeViewSchema.isRestrict((TsTable)table));
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return this.columnHeaderList;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo schemaInfo, TsBlockBuilder builder, String database) {
        if (!this.needAligned) {
            TableDeviceQuerySource.transformToTableDeviceTsBlockColumns(schemaInfo, builder, this.columnSchemaList, this.tagIndex);
        } else {
            this.transformToTreeDeviceTsBlockColumns(schemaInfo, builder, this.columnSchemaList, this.tagIndex, database);
        }
    }

    public static void transformToTableDeviceTsBlockColumns(IDeviceSchemaInfo schemaInfo, TsBlockBuilder builder, List<TsTableColumnSchema> columnSchemaList, int tagIndex) {
        builder.getTimeColumnBuilder().writeLong(0L);
        int resultIndex = 0;
        String[] pathNodes = schemaInfo.getRawNodes();
        for (TsTableColumnSchema columnSchema : columnSchemaList) {
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                if (pathNodes.length <= tagIndex || pathNodes[tagIndex] == null) {
                    builder.getColumnBuilder(resultIndex).appendNull();
                } else {
                    builder.getColumnBuilder(resultIndex).writeBinary(new Binary(pathNodes[tagIndex], TSFileConfig.STRING_CHARSET));
                }
                ++tagIndex;
            } else if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)) {
                Binary attributeValue = schemaInfo.getAttributeValue(columnSchema.getColumnName());
                if (attributeValue == null) {
                    builder.getColumnBuilder(resultIndex).appendNull();
                } else {
                    builder.getColumnBuilder(resultIndex).writeBinary(attributeValue);
                }
            }
            ++resultIndex;
        }
        builder.declarePosition();
    }

    private void transformToTreeDeviceTsBlockColumns(IDeviceSchemaInfo schemaInfo, TsBlockBuilder builder, List<TsTableColumnSchema> columnSchemaList, int beginIndex, String database) {
        builder.getTimeColumnBuilder().writeLong(0L);
        int resultIndex = 0;
        String[] pathNodes = schemaInfo.getRawNodes();
        for (TsTableColumnSchema columnSchema : columnSchemaList) {
            if (!Objects.nonNull(columnSchema) || !columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) continue;
            if (pathNodes.length <= resultIndex + beginIndex || pathNodes[resultIndex + beginIndex] == null) {
                builder.getColumnBuilder(resultIndex).appendNull();
            } else {
                builder.getColumnBuilder(resultIndex).writeBinary(new Binary(pathNodes[resultIndex + beginIndex], TSFileConfig.STRING_CHARSET));
            }
            ++resultIndex;
        }
        builder.getColumnBuilder(resultIndex).writeBoolean(schemaInfo.isAligned().booleanValue());
        if (builder.getPositionCount() == 0) {
            builder.getValueColumnBuilders()[resultIndex + 1] = new RleBinaryColumnBuilder((BinaryColumnBuilder)builder.getColumnBuilder(resultIndex + 1));
        }
        builder.getColumnBuilder(resultIndex + 1).writeBinary(new Binary(database, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return (Objects.isNull(this.tagDeterminedPredicateList) || this.tagDeterminedPredicateList.isEmpty() || this.tagDeterminedPredicateList.stream().allMatch(List::isEmpty)) && Objects.isNull(this.filter) && PathUtils.isTableModelDatabase((String)schemaRegion.getDatabaseFullPath());
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return schemaRegion.getSchemaRegionStatistics().getTableDevicesNumber(this.table.getTableName());
    }

    @Override
    public long getMaxMemory(ISchemaRegion schemaRegion) {
        ISchemaRegionStatistics statistics = schemaRegion.getSchemaRegionStatistics();
        String tableName = this.table.getTableName();
        long devicesNumber = statistics.getTableDevicesNumber(tableName);
        return !TreeViewSchema.isTreeViewTable((TsTable)this.table) && this.devicePatternList.stream().allMatch(path -> ((ExtendedPartialPath)path).isNormalPath() && Arrays.stream(path.getNodes()).noneMatch(PathPatternUtil::hasWildcard)) ? Math.min((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), this.devicePatternList.stream().map(devicePattern -> Arrays.stream(devicePattern.getNodes(), 3, devicePattern.getNodeLength()).map(RamUsageEstimator::sizeOf).reduce(0L, Long::sum)).reduce(0L, Long::sum) + (devicesNumber > 0L ? (long)this.devicePatternList.size() * statistics.getTableAttributeMemory(tableName) / devicesNumber : 0L)) : (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    }

    private static class RleBinaryColumnBuilder
    extends BinaryColumnBuilder {
        private final BinaryColumnBuilder innerBuilder;
        private int realPositionCount = 0;

        public RleBinaryColumnBuilder(BinaryColumnBuilder innerBuilder) {
            super(null, 0);
            this.innerBuilder = innerBuilder;
        }

        public int getPositionCount() {
            return this.realPositionCount;
        }

        public ColumnBuilder writeBinary(Binary value) {
            if (this.realPositionCount == 0) {
                this.innerBuilder.writeBinary(value);
            }
            ++this.realPositionCount;
            return this;
        }

        public ColumnBuilder appendNull() {
            return this.innerBuilder.appendNull();
        }

        public Column build() {
            return new RunLengthEncodedColumn(this.innerBuilder.build(), this.realPositionCount);
        }

        public long getRetainedSizeInBytes() {
            return this.innerBuilder.getRetainedSizeInBytes();
        }
    }
}

