/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionArgument;

public class TableFunctionInvocation
extends Relation {
    private final QualifiedName name;
    private final List<TableFunctionArgument> arguments;

    public TableFunctionInvocation(NodeLocation location, QualifiedName name, List<TableFunctionArgument> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<TableFunctionArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunctionInvocation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFunctionInvocation that = (TableFunctionInvocation)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    @Override
    public String toString() {
        return this.name + "(" + this.arguments.stream().map(TableFunctionArgument::toString).collect(Collectors.joining(", ")) + ")";
    }

    @Override
    public boolean shallowEquals(Node o) {
        if (!TableFunctionInvocation.sameClass(this, o)) {
            return false;
        }
        TableFunctionInvocation other = (TableFunctionInvocation)o;
        return Objects.equals(this.name, other.name);
    }
}

