/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.james.jdkim.tagvalue.PublicKeyRecordImpl;
import org.junit.Assert;
import org.junit.Test;

public class PublicKeyRecordTest {
    @Test
    public void testValidate() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("");
        try {
            pkr.validate();
            Assert.fail((String)"Expected failure: missing mandatory parameters");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        pkr = new PublicKeyRecordImpl("v=DKIM1; k=rsa; p=XXXXXX=");
        pkr.validate();
        pkr = new PublicKeyRecordImpl(" v=DKIM1; k=rsa; p=XXXXXX=");
        pkr.validate();
        pkr = new PublicKeyRecordImpl("k=rsa; v=DKIM1; p=XXXXXX=");
        try {
            pkr.validate();
            Assert.fail((String)"Expected failure: v should be the first");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        pkr = new PublicKeyRecordImpl("v=DKIM2; k=rsa; p=XXXXXX=");
        try {
            pkr.validate();
            Assert.fail((String)"Expected failure: wrong version");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        pkr = new PublicKeyRecordImpl("v=DKIM1; k=rsa; p=");
        try {
            pkr.validate();
            Assert.fail((String)"Expected failure: revoked key");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIsHashMethodSupported() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        Assert.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha1"));
        Assert.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha256"));
        pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        Assert.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha1"));
        Assert.assertFalse((boolean)pkr.isHashMethodSupported((CharSequence)"sha128"));
        Assert.assertTrue((boolean)pkr.isHashMethodSupported((CharSequence)"sha256"));
    }

    @Test
    public void testIsKeyTypeSupported() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        Assert.assertTrue((boolean)pkr.isKeyTypeSupported((CharSequence)"rsa"));
        Assert.assertFalse((boolean)pkr.isKeyTypeSupported((CharSequence)"dsa"));
    }

    @Test
    public void testGetAcceptableHashMethods() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        List methods = pkr.getAcceptableHashMethods();
        Assert.assertEquals((Object)"[sha1, sha256]", (Object)methods.toString());
        pkr = new PublicKeyRecordImpl("k=rsa; p=XXXXXXXX=;");
        pkr.validate();
        methods = pkr.getAcceptableHashMethods();
        Assert.assertNull((Object)methods);
    }

    @Test
    public void testGetAcceptableKeyTypes() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        List methods = pkr.getAcceptableKeyTypes();
        Assert.assertEquals((Object)"[rsa]", (Object)methods.toString());
        pkr = new PublicKeyRecordImpl("k=rsa:dsa; p=XXXXXXXX=;");
        pkr.validate();
        methods = pkr.getAcceptableKeyTypes();
        Assert.assertEquals((Object)"[rsa, dsa]", (Object)methods.toString());
    }

    @Test
    public void testGetGranularityPattern() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        Pattern pattern = pkr.getGranularityPattern();
        Assert.assertEquals((Object)"^\\Q\\E.*\\Q\\E$", (Object)pattern.pattern());
        Assert.assertTrue((boolean)pattern.matcher("something").matches());
        Assert.assertTrue((boolean)pattern.matcher("").matches());
        pkr = new PublicKeyRecordImpl("k=rsa; g=; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        Assert.assertEquals((Object)"@", (Object)pattern.pattern());
        Assert.assertFalse((boolean)pattern.matcher("something").matches());
        Assert.assertFalse((boolean)pattern.matcher("").matches());
        pkr = new PublicKeyRecordImpl("k=rsa; g=some*; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        Assert.assertTrue((boolean)pattern.matcher("something").matches());
        Assert.assertTrue((boolean)pattern.matcher("some").matches());
        Assert.assertFalse((boolean)pattern.matcher("som").matches());
        Assert.assertFalse((boolean)pattern.matcher("awesome").matches());
        Assert.assertEquals((Object)"^\\Qsome\\E.*\\Q\\E$", (Object)pattern.pattern());
        pkr = new PublicKeyRecordImpl("k=rsa; g=*+test; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        Assert.assertEquals((Object)"^\\Q\\E.*\\Q+test\\E$", (Object)pattern.pattern());
        Assert.assertTrue((boolean)pattern.matcher("a+test").matches());
        Assert.assertTrue((boolean)pattern.matcher("+test").matches());
        Assert.assertFalse((boolean)pattern.matcher("atest").matches());
        Assert.assertFalse((boolean)pattern.matcher("+tested").matches());
        pkr = new PublicKeyRecordImpl("k=rsa; g=test; h=sha1:sha256; p=XXXXXXXX=;");
        pkr.validate();
        pattern = pkr.getGranularityPattern();
        Assert.assertEquals((Object)"^\\Qtest\\E$", (Object)pattern.pattern());
        Assert.assertTrue((boolean)pattern.matcher("test").matches());
        Assert.assertFalse((boolean)pattern.matcher("atest").matches());
        Assert.assertFalse((boolean)pattern.matcher("testa").matches());
        try {
            pkr = new PublicKeyRecordImpl("k=rsa; g=*\\+test; h=sha1:sha256; p=XXXXXXXX=;");
            pkr.validate();
            pattern = pkr.getGranularityPattern();
            Assert.fail((String)"Expected syntax error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            pkr = new PublicKeyRecordImpl("k=rsa; g=*test*; h=sha1:sha256; p=XXXXXXXX=;");
            pkr.validate();
            pattern = pkr.getGranularityPattern();
            Assert.fail((String)"Expected syntax error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPublicKey() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        PublicKey pk = pkr.getPublicKey();
        Assert.assertEquals((Object)"RSA", (Object)pk.getAlgorithm());
        Assert.assertEquals((Object)new BigInteger("140815480285950232210124449496973988135931539914762288985377502488754711434253259186192434865594456027796377309280714060984552676169392598862819043219650259702261370701494928576447797673342985377518637829874968725582762257956980427968667812066816497848410406856165942400151628259779523949079651036806330485849"), (Object)((RSAKey)((Object)pk)).getModulus());
        try {
            pkr = new PublicKeyRecordImpl("k=dsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
            pkr.validate();
            pk = pkr.getPublicKey();
            Assert.fail((String)"Expected invalid key spec. DSA is not supported");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            pkr = new PublicKeyRecordImpl("k=unknown; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
            pkr.validate();
            pk = pkr.getPublicKey();
            Assert.fail((String)"Expected invalid algorythm. 'unknown' is not supported");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFlags() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y:s; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        List flags = pkr.getFlags();
        Assert.assertEquals((Object)"[y, s]", (Object)flags.toString());
        pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        flags = pkr.getFlags();
        Assert.assertEquals((Object)"[y]", (Object)flags.toString());
        pkr = new PublicKeyRecordImpl("k=rsa; t=; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        flags = pkr.getFlags();
        Assert.assertEquals((Object)"[]", (Object)flags.toString());
    }

    @Test
    public void testIsTesting() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y:s; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        Assert.assertTrue((boolean)pkr.isTesting());
        pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        Assert.assertTrue((boolean)pkr.isTesting());
        pkr = new PublicKeyRecordImpl("k=rsa; t=; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        Assert.assertFalse((boolean)pkr.isTesting());
    }

    @Test
    public void testIsDenySubdomains() {
        PublicKeyRecordImpl pkr = new PublicKeyRecordImpl("k=rsa; t=y:s; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        Assert.assertTrue((boolean)pkr.isDenySubdomains());
        pkr = new PublicKeyRecordImpl("k=rsa; t=y; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        Assert.assertFalse((boolean)pkr.isDenySubdomains());
        pkr = new PublicKeyRecordImpl("k=rsa; t=; p=MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDIhyR3oItOy22ZOaBrIVe9m/iME3RqOJeasANSpg2YTHTYV+Xtp4xwf5gTjCmHQEMOs0qYu0FYiNQPQogJ2t0Mfx9zNu06rfRBDjiIU9tpx2T+NGlWZ8qhbiLo5By8apJavLyqTLavyPSrvsx0B3YzC63T4Age2CDqZYA+OwSMWQIDAQAB");
        pkr.validate();
        Assert.assertFalse((boolean)pkr.isDenySubdomains());
    }
}

