/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.TestCase;

public abstract class AbstractOutputStreamTestCase
extends TestCase {
    protected AbstractOutputStreamTestCase() {
    }

    public void chunker(BufferedInputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[307];
        int chunksCounter = 0;
        while ((read = is.read(buffer, 0, buffer.length / (chunksCounter % 8 + 1))) > 0) {
            if (read == buffer.length && chunksCounter % 13 % 7 % 2 == 1) {
                os.write(buffer);
            } else if (chunksCounter % 11 != 0) {
                os.write(buffer, 0, read);
            } else {
                for (int i = 0; i < read; ++i) {
                    os.write(buffer[i]);
                }
            }
            if (chunksCounter % 3 == 2) {
                os.flush();
            }
            ++chunksCounter;
        }
        os.close();
    }

    public void chunker(byte[] data, OutputStream os) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(data));
        this.chunker(is, os);
    }

    public void writeChunk(OutputStream os, byte[] data, int from, int len) throws IOException {
        if (len == 1) {
            os.write(data[from]);
        } else if (len == data.length) {
            os.write(data);
        } else {
            os.write(data, from, len);
        }
    }

    public void assertArrayEquals(String explanation, byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            AbstractOutputStreamTestCase.assertEquals((String)explanation, (String)new String(expected), (String)new String(actual));
        }
    }

    public void assertArrayEquals(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            AbstractOutputStreamTestCase.assertEquals((String)new String(expected), (String)new String(actual));
        }
    }

    protected OutputStream newInstance(ByteArrayOutputStream bos) {
        throw new IllegalStateException("Implement newInstance in order to use extensive chunker");
    }

    public void extensiveChunker(byte[] data, byte[] expectedData) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            for (int j = i; j < data.length; ++j) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                OutputStream os = this.newInstance(bos);
                this.writeChunk(os, data, 0, i);
                this.writeChunk(os, data, i, j - i);
                this.writeChunk(os, data, j, data.length - j);
                os.close();
                this.assertArrayEquals("i=" + i + ", j=" + j + ", l=" + data.length, expectedData, bos.toByteArray());
            }
        }
    }
}

