/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.utils.ExtensionConfiguration;
import org.apache.james.utils.GuiceGenericLoader;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.LoggerFactory;

public class ExtensionModule
extends AbstractModule {
    protected void configure() {
        this.bind(GuiceGenericLoader.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    ExtensionConfiguration extensionConfiguration(PropertiesProvider propertiesProvider) {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("extensions");
            return ExtensionConfiguration.from(configuration);
        }
        catch (FileNotFoundException | ConfigurationException e) {
            LoggerFactory.getLogger(ExtensionModule.class).info("No extensions.properties configuration found. No additional Guice module will be used for instantiating extensions.");
            return ExtensionConfiguration.DEFAULT;
        }
    }
}

