/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.LogEnabled;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.MacroExpand;
import org.apache.james.jspf.core.MacroExpandEnabled;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.ConfigurationEnabled;
import org.apache.james.jspf.terms.Mechanism;

public abstract class GenericMechanism
implements Mechanism,
ConfigurationEnabled,
LogEnabled,
MacroExpandEnabled {
    protected static final String IP4_CIDR_LENGTH_REGEX = "/(\\d+)";
    protected static final String IP6_CIDR_LENGTH_REGEX = "/(\\d+)";
    protected static final String DUAL_CIDR_LENGTH_REGEX = "(?:/(\\d+))?(?://(\\d+))?";
    private String domain;
    protected Logger log;
    protected MacroExpand macroExpand;

    protected String expandHost(SPFSession spfData) throws PermErrorException {
        String host = this.getDomain();
        host = host == null ? spfData.getCurrentDomain() : this.macroExpand.expand(host, spfData, false);
        return host;
    }

    public synchronized void config(Configuration params) throws PermErrorException {
        this.domain = params.groupCount() >= 1 && params.group(1) != null ? params.group(1) : null;
    }

    protected synchronized String getDomain() {
        return this.domain;
    }

    public void enableLogging(Logger logger) {
        this.log = logger;
    }

    public void enableMacroExpand(MacroExpand macroExpand) {
        this.macroExpand = macroExpand;
    }
}

