/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTypeManager;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.AesCmacKey;
import com.google.crypto.tink.proto.AesCmacKeyFormat;
import com.google.crypto.tink.proto.AesCmacParams;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.PrfAesCmac;
import com.google.crypto.tink.subtle.PrfMac;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AesCmacKeyManager
extends KeyTypeManager<AesCmacKey> {
    private static final int VERSION = 0;
    private static final int KEY_SIZE_IN_BYTES = 32;
    private static final int MIN_TAG_SIZE_IN_BYTES = 10;
    private static final int MAX_TAG_SIZE_IN_BYTES = 16;

    AesCmacKeyManager() {
        super(AesCmacKey.class, new KeyTypeManager.PrimitiveFactory<Mac, AesCmacKey>(Mac.class){

            @Override
            public Mac getPrimitive(AesCmacKey key) throws GeneralSecurityException {
                return new PrfMac(new PrfAesCmac(key.getKeyValue().toByteArray()), key.getParams().getTagSize());
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.AesCmacKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(AesCmacKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        AesCmacKeyManager.validateSize(key.getKeyValue().size());
        AesCmacKeyManager.validateParams(key.getParams());
    }

    @Override
    public AesCmacKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return AesCmacKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    private static void validateParams(AesCmacParams params) throws GeneralSecurityException {
        if (params.getTagSize() < 10) {
            throw new GeneralSecurityException("tag size too short");
        }
        if (params.getTagSize() > 16) {
            throw new GeneralSecurityException("tag size too long");
        }
    }

    private static void validateSize(int size) throws GeneralSecurityException {
        if (size != 32) {
            throw new GeneralSecurityException("AesCmacKey size wrong, must be 32 bytes");
        }
    }

    @Override
    public KeyTypeManager.KeyFactory<AesCmacKeyFormat, AesCmacKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<AesCmacKeyFormat, AesCmacKey>(AesCmacKeyFormat.class){

            @Override
            public void validateKeyFormat(AesCmacKeyFormat format) throws GeneralSecurityException {
                AesCmacKeyManager.validateParams(format.getParams());
                AesCmacKeyManager.validateSize(format.getKeySize());
            }

            @Override
            public AesCmacKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return AesCmacKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public AesCmacKey createKey(AesCmacKeyFormat format) throws GeneralSecurityException {
                return AesCmacKey.newBuilder().setVersion(0).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).setParams(format.getParams()).build();
            }

            @Override
            public Map<String, KeyTypeManager.KeyFactory.KeyFormat<AesCmacKeyFormat>> keyFormats() throws GeneralSecurityException {
                HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<AesCmacKeyFormat>> result = new HashMap<String, KeyTypeManager.KeyFactory.KeyFormat<AesCmacKeyFormat>>();
                result.put("AES_CMAC", new KeyTypeManager.KeyFactory.KeyFormat<AesCmacKeyFormat>(AesCmacKeyFormat.newBuilder().setKeySize(32).setParams(AesCmacParams.newBuilder().setTagSize(16).build()).build(), KeyTemplate.OutputPrefixType.TINK));
                result.put("AES256_CMAC", new KeyTypeManager.KeyFactory.KeyFormat<AesCmacKeyFormat>(AesCmacKeyFormat.newBuilder().setKeySize(32).setParams(AesCmacParams.newBuilder().setTagSize(16).build()).build(), KeyTemplate.OutputPrefixType.TINK));
                result.put("AES256_CMAC_RAW", new KeyTypeManager.KeyFactory.KeyFormat<AesCmacKeyFormat>(AesCmacKeyFormat.newBuilder().setKeySize(32).setParams(AesCmacParams.newBuilder().setTagSize(16).build()).build(), KeyTemplate.OutputPrefixType.RAW));
                return Collections.unmodifiableMap(result);
            }
        };
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new AesCmacKeyManager(), newKeyAllowed);
    }

    @Deprecated
    public static final KeyTemplate aes256CmacTemplate() {
        AesCmacKeyFormat format = AesCmacKeyFormat.newBuilder().setKeySize(32).setParams(AesCmacParams.newBuilder().setTagSize(16).build()).build();
        return KeyTemplate.create(new AesCmacKeyManager().getKeyType(), format.toByteArray(), KeyTemplate.OutputPrefixType.TINK);
    }

    @Deprecated
    public static final KeyTemplate rawAes256CmacTemplate() {
        AesCmacKeyFormat format = AesCmacKeyFormat.newBuilder().setKeySize(32).setParams(AesCmacParams.newBuilder().setTagSize(16).build()).build();
        return KeyTemplate.create(new AesCmacKeyManager().getKeyType(), format.toByteArray(), KeyTemplate.OutputPrefixType.RAW);
    }
}

