/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import java.time.Instant;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.api.DeleteCondition;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueMailDelete;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueMailStore;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraMailQueueView
implements MailQueueView<CassandraMailQueueBrowser.CassandraMailQueueItemView> {
    private static final int DELETION_CONCURRENCY = 8;
    private final CassandraMailQueueMailStore storeHelper;
    private final CassandraMailQueueBrowser cassandraMailQueueBrowser;
    private final CassandraMailQueueMailDelete cassandraMailQueueMailDelete;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
    private final MailQueueName mailQueueName;

    CassandraMailQueueView(CassandraMailQueueMailStore storeHelper, MailQueueName mailQueueName, CassandraMailQueueBrowser cassandraMailQueueBrowser, CassandraMailQueueMailDelete cassandraMailQueueMailDelete, Store<MimeMessage, MimeMessagePartsId> mimeMessageStore) {
        this.mailQueueName = mailQueueName;
        this.storeHelper = storeHelper;
        this.cassandraMailQueueBrowser = cassandraMailQueueBrowser;
        this.cassandraMailQueueMailDelete = cassandraMailQueueMailDelete;
        this.mimeMessageStore = mimeMessageStore;
    }

    public Mono<Void> updateBrowseStart() {
        return this.cassandraMailQueueMailDelete.updateBrowseStartReactive(this.mailQueueName);
    }

    @Override
    public void initialize(MailQueueName mailQueueName) {
        this.storeHelper.initializeBrowseStart(mailQueueName).block();
        this.storeHelper.initializeContentStart(mailQueueName).block();
    }

    @Override
    public Mono<Void> storeMail(EnqueuedItem enqueuedItem) {
        return this.storeHelper.storeMail(enqueuedItem);
    }

    @Override
    public ManageableMailQueue.MailQueueIterator browse() {
        return new CassandraMailQueueBrowser.CassandraMailQueueIterator(this.browseReactive().toIterable().iterator());
    }

    @Override
    public Flux<CassandraMailQueueBrowser.CassandraMailQueueItemView> browseReactive() {
        return this.cassandraMailQueueBrowser.browse(this.mailQueueName).subscribeOn(Schedulers.elastic());
    }

    @Override
    public Flux<CassandraMailQueueBrowser.CassandraMailQueueItemView> browseOlderThanReactive(Instant olderThan) {
        return this.cassandraMailQueueBrowser.browseOlderThan(this.mailQueueName, olderThan).subscribeOn(Schedulers.elastic());
    }

    @Override
    public long getSize() {
        return (Long)this.cassandraMailQueueBrowser.browseReferences(this.mailQueueName).count().subscribeOn(Schedulers.elastic()).block();
    }

    public Mono<Long> delete(DeleteCondition deleteCondition) {
        if (deleteCondition instanceof DeleteCondition.WithEnqueueId) {
            DeleteCondition.WithEnqueueId enqueueIdCondition = (DeleteCondition.WithEnqueueId)deleteCondition;
            return this.delete(enqueueIdCondition.getEnqueueId(), enqueueIdCondition.getBlobIds()).thenReturn((Object)1L);
        }
        return this.browseThenDelete(deleteCondition);
    }

    private Mono<Long> browseThenDelete(DeleteCondition deleteCondition) {
        return this.cassandraMailQueueBrowser.browseReferences(this.mailQueueName).map(EnqueuedItemWithSlicingContext::getEnqueuedItem).filter(deleteCondition::shouldBeDeleted).flatMap(mailReference -> this.cassandraMailQueueMailDelete.considerDeleted(mailReference.getEnqueueId(), this.mailQueueName).then(Mono.from((Publisher)this.mimeMessageStore.delete((Object)mailReference.getPartsId()))), 8).count().doOnNext(ignored -> this.cassandraMailQueueMailDelete.updateBrowseStart(this.mailQueueName));
    }

    private Mono<Void> delete(EnqueueId enqueueId, MimeMessagePartsId blobIds) {
        return this.cassandraMailQueueMailDelete.considerDeleted(enqueueId, this.mailQueueName).then(Mono.from((Publisher)this.mimeMessageStore.delete((Object)blobIds)));
    }

    @Override
    public Mono<Boolean> isPresent(EnqueueId id) {
        return this.cassandraMailQueueMailDelete.isDeleted(id, this.mailQueueName).map(FunctionalUtils.negate());
    }

    public static class Factory
    implements MailQueueView.Factory {
        private final CassandraMailQueueMailStore storeHelper;
        private final CassandraMailQueueBrowser cassandraMailQueueBrowser;
        private final CassandraMailQueueMailDelete cassandraMailQueueMailDelete;
        private final MimeMessageStore.Factory mimeMessageStoreFactory;

        @Inject
        public Factory(CassandraMailQueueMailStore storeHelper, CassandraMailQueueBrowser cassandraMailQueueBrowser, CassandraMailQueueMailDelete cassandraMailQueueMailDelete, MimeMessageStore.Factory mimeMessageStoreFactory) {
            this.storeHelper = storeHelper;
            this.cassandraMailQueueBrowser = cassandraMailQueueBrowser;
            this.cassandraMailQueueMailDelete = cassandraMailQueueMailDelete;
            this.mimeMessageStoreFactory = mimeMessageStoreFactory;
        }

        @Override
        public MailQueueView create(MailQueueName mailQueueName) {
            return new CassandraMailQueueView(this.storeHelper, mailQueueName, this.cassandraMailQueueBrowser, this.cassandraMailQueueMailDelete, (Store<MimeMessage, MimeMessagePartsId>)this.mimeMessageStoreFactory.mimeMessageStore());
        }
    }
}

