/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.tagvalue;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.james.jdkim.api.PublicKeyRecord;
import org.apache.james.jdkim.codec.binary.Base64;
import org.apache.james.jdkim.tagvalue.TagValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicKeyRecordImpl
extends TagValue
implements PublicKeyRecord {
    private static final String atom = "[a-zA-Z0-9!#$%&'*+/=?^_`{}|~-]+";
    private static final String dotAtomText = "([a-zA-Z0-9!#$%&'*+/=?^_`{}|~-]+)?\\*?([a-zA-Z0-9!#$%&'*+/=?^_`{}|~-]+)?";
    private static final Pattern granularityPattern = Pattern.compile("^([a-zA-Z0-9!#$%&'*+/=?^_`{}|~-]+)?\\*?([a-zA-Z0-9!#$%&'*+/=?^_`{}|~-]+)?$");
    private static Pattern hyphenatedWordPattern = Pattern.compile("^[a-zA-Z]([a-zA-Z0-9-]*[a-zA-Z0-9])?$");

    public PublicKeyRecordImpl(String data) {
        super(data);
    }

    @Override
    protected Map<String, CharSequence> newTagValue() {
        return new LinkedHashMap<String, CharSequence>();
    }

    @Override
    protected void init() {
        this.mandatoryTags.add("p");
        this.defaults.put("v", "DKIM1");
        this.defaults.put("g", "*");
        this.defaults.put("h", ";any;");
        this.defaults.put("k", "rsa");
        this.defaults.put("s", "*");
        this.defaults.put("t", "");
    }

    @Override
    public void validate() {
        String firstKey;
        super.validate();
        if (this.containsTag("v") && !"v".equals(firstKey = this.tagSet().iterator().next())) {
            throw new IllegalStateException("Existing v= tag MUST be the first in the record list (" + firstKey + ")");
        }
        if (!"DKIM1".equals(this.getValue("v"))) {
            throw new IllegalStateException("Unknown version for v= (expected DKIM1): " + this.getValue("v"));
        }
        if ("".equals(this.getValue("p"))) {
            throw new IllegalStateException("Revoked key. 'p=' in record");
        }
    }

    @Override
    public boolean isHashMethodSupported(CharSequence hash) {
        List<CharSequence> hashes = this.getAcceptableHashMethods();
        if (hashes == null) {
            return true;
        }
        return this.isInListCaseInsensitive(hash, hashes);
    }

    @Override
    public boolean isKeyTypeSupported(CharSequence hash) {
        List<CharSequence> hashes = this.getAcceptableKeyTypes();
        return this.isInListCaseInsensitive(hash, hashes);
    }

    @Override
    public List<CharSequence> getAcceptableHashMethods() {
        if (";any;".equals(this.getValue("h"))) {
            return null;
        }
        return this.stringToColonSeparatedList(((Object)this.getValue("h")).toString(), hyphenatedWordPattern);
    }

    @Override
    public List<CharSequence> getAcceptableKeyTypes() {
        return this.stringToColonSeparatedList(((Object)this.getValue("k")).toString(), hyphenatedWordPattern);
    }

    @Override
    public Pattern getGranularityPattern() {
        String g = ((Object)this.getValue("g")).toString();
        int pStar = g.indexOf(42);
        if (!granularityPattern.matcher(g).matches()) {
            throw new IllegalStateException("Syntax error in granularity: " + g);
        }
        if (g.length() == 0) {
            return Pattern.compile("@");
        }
        if (pStar != -1) {
            if (g.indexOf(42, pStar + 1) != -1) {
                throw new IllegalStateException("Invalid granularity using more than one wildcard: " + g);
            }
            String pattern = "^\\Q" + ((Object)g.subSequence(0, pStar)).toString() + "\\E.*\\Q" + ((Object)g.subSequence(pStar + 1, g.length())).toString() + "\\E$";
            return Pattern.compile(pattern);
        }
        return Pattern.compile("^\\Q" + g + "\\E$");
    }

    @Override
    public List<CharSequence> getFlags() {
        String flags = ((Object)this.getValue("t")).toString();
        String[] flagsStrings = flags.split(":");
        ArrayList<CharSequence> res = new ArrayList<CharSequence>();
        for (int i = 0; i < flagsStrings.length; ++i) {
            res.add(this.trimFWS(flagsStrings[i], 0, flagsStrings[i].length() - 1, true));
        }
        return res;
    }

    @Override
    public boolean isDenySubdomains() {
        return this.getFlags().contains("s");
    }

    @Override
    public boolean isTesting() {
        return this.getFlags().contains("y");
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            String p = ((Object)this.getValue("p")).toString();
            byte[] key = Base64.decodeBase64(p.getBytes());
            KeyFactory keyFactory = KeyFactory.getInstance(((Object)this.getValue("k")).toString());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(key);
            RSAPublicKey rsaKey = (RSAPublicKey)keyFactory.generatePublic(pubSpec);
            return rsaKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unknown algorithm: " + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalStateException("Invalid key spec: " + e.getMessage());
        }
    }
}

