/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;

public class PutCalendarJobRequest
extends ActionRequest {
    private final List<String> jobIds;
    private final String calendarId;

    public PutCalendarJobRequest(String calendarId, String ... jobIds) {
        this.calendarId = Objects.requireNonNull(calendarId, "[calendar_id] must not be null.");
        if (jobIds.length == 0) {
            throw new InvalidParameterException("jobIds must not be empty.");
        }
        if (Arrays.stream(jobIds).anyMatch(Objects::isNull)) {
            throw new NullPointerException("jobIds must not contain null values.");
        }
        this.jobIds = Arrays.asList(jobIds);
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.jobIds, this.calendarId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        PutCalendarJobRequest that = (PutCalendarJobRequest)((Object)other);
        return Objects.equals(this.jobIds, that.jobIds) && Objects.equals(this.calendarId, that.calendarId);
    }
}

