/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.util.StreamUtils;
import org.apache.james.utils.FullyQualifiedClassName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedClassLoader.class);
    public static final String EXTENSIONS_JARS_FOLDER_NAME = "extensions-jars/";
    private final URLClassLoader urlClassLoader;

    @Inject
    public ExtendedClassLoader(FileSystem fileSystem) {
        this.urlClassLoader = new URLClassLoader(this.retrieveExtensionsUrls(fileSystem), this.getClass().getClassLoader());
    }

    private URL[] retrieveExtensionsUrls(FileSystem fileSystem) {
        try {
            File file = fileSystem.getFile("file://extensions-jars/");
            return (URL[])this.recursiveExpand(file).toArray(URL[]::new);
        }
        catch (IOException e) {
            LOGGER.info("No extensions-jars/ folder.");
            return new URL[0];
        }
    }

    private Stream<URL> recursiveExpand(File file) {
        return StreamUtils.ofNullable((Object[])file.listFiles()).flatMap(Throwing.function(this::expandFile).sneakyThrow());
    }

    private Stream<URL> expandFile(File file) throws MalformedURLException {
        if (file.isDirectory()) {
            return this.recursiveExpand(file);
        }
        LOGGER.info("Loading custom classpath resource {}", (Object)file.getAbsolutePath());
        return Stream.of(file.toURI().toURL());
    }

    public <T> Class<T> locateClass(FullyQualifiedClassName className) throws ClassNotFoundException {
        return this.urlClassLoader.loadClass(className.getName());
    }
}

