/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.user.ldap.ReadOnlyLDAPGroupRestriction;

public class LdapRepositoryConfiguration {
    public static final String SUPPORTS_VIRTUAL_HOSTING = "supportsVirtualHosting";
    private static final int NO_CONNECTION_TIMEOUT = 0;
    private static final int NO_READ_TIME_OUT = 0;
    private static final boolean ENABLE_VIRTUAL_HOSTING = true;
    private static final ReadOnlyLDAPGroupRestriction NO_RESTRICTION = new ReadOnlyLDAPGroupRestriction(null);
    private static final String NO_FILTER = null;
    private static final Optional<String> NO_ADMINISTRATOR_ID = Optional.empty();
    private static final int DEFAULT_POOL_SIZE = 4;
    private final String ldapHost;
    private final String principal;
    private final String credentials;
    private final String userBase;
    private final String userIdAttribute;
    private final String userObjectClass;
    private final int connectionTimeout;
    private final int readTimeout;
    private final boolean supportsVirtualHosting;
    private final int poolSize;
    private final ReadOnlyLDAPGroupRestriction restriction;
    private final String filter;
    private final Optional<Username> administratorId;

    public static Builder builder() {
        return new Builder();
    }

    public static LdapRepositoryConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        String ldapHost = configuration.getString("[@ldapHost]", "");
        String principal = configuration.getString("[@principal]", "");
        String credentials = configuration.getString("[@credentials]", "");
        String userBase = configuration.getString("[@userBase]");
        String userIdAttribute = configuration.getString("[@userIdAttribute]");
        String userObjectClass = configuration.getString("[@userObjectClass]");
        int connectionTimeout = configuration.getInt("[@connectionTimeout]", 0);
        int readTimeout = configuration.getInt("[@readTimeout]", 0);
        boolean supportsVirtualHosting = configuration.getBoolean(SUPPORTS_VIRTUAL_HOSTING, false);
        HierarchicalConfiguration restrictionConfig = null;
        if (configuration.containsKey("restriction[@memberAttribute]")) {
            restrictionConfig = configuration.configurationAt("restriction");
        }
        ReadOnlyLDAPGroupRestriction restriction = new ReadOnlyLDAPGroupRestriction((HierarchicalConfiguration<ImmutableNode>)restrictionConfig);
        String filter = configuration.getString("[@filter]");
        Optional<String> administratorId = Optional.ofNullable(configuration.getString("[@administratorId]"));
        int poolSize = Optional.ofNullable(configuration.getInteger("[@poolSize]", null)).orElse(4);
        return new LdapRepositoryConfiguration(ldapHost, principal, credentials, userBase, userIdAttribute, userObjectClass, connectionTimeout, readTimeout, supportsVirtualHosting, poolSize, restriction, filter, administratorId);
    }

    private LdapRepositoryConfiguration(String ldapHost, String principal, String credentials, String userBase, String userIdAttribute, String userObjectClass, int connectionTimeout, int readTimeout, boolean supportsVirtualHosting, int poolSize, ReadOnlyLDAPGroupRestriction restriction, String filter, Optional<String> administratorId) throws ConfigurationException {
        this.ldapHost = ldapHost;
        this.principal = principal;
        this.credentials = credentials;
        this.userBase = userBase;
        this.userIdAttribute = userIdAttribute;
        this.userObjectClass = userObjectClass;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.supportsVirtualHosting = supportsVirtualHosting;
        this.poolSize = poolSize;
        this.restriction = restriction;
        this.filter = filter;
        this.administratorId = administratorId.map(Username::of);
        this.checkState();
    }

    private void checkState() throws ConfigurationException {
        if (this.userBase == null) {
            throw new ConfigurationException("[@userBase] is mandatory");
        }
        if (this.userIdAttribute == null) {
            throw new ConfigurationException("[@userIdAttribute] is mandatory");
        }
        if (this.userObjectClass == null) {
            throw new ConfigurationException("[@userObjectClass] is mandatory");
        }
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean supportsVirtualHosting() {
        return this.supportsVirtualHosting;
    }

    public ReadOnlyLDAPGroupRestriction getRestriction() {
        return this.restriction;
    }

    public String getFilter() {
        return this.filter;
    }

    public Optional<Username> getAdministratorId() {
        return this.administratorId;
    }

    public final boolean equals(Object o) {
        if (o instanceof LdapRepositoryConfiguration) {
            LdapRepositoryConfiguration that = (LdapRepositoryConfiguration)o;
            return Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.supportsVirtualHosting, that.supportsVirtualHosting) && Objects.equals(this.ldapHost, that.ldapHost) && Objects.equals(this.principal, that.principal) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.userBase, that.userBase) && Objects.equals(this.userIdAttribute, that.userIdAttribute) && Objects.equals(this.userObjectClass, that.userObjectClass) && Objects.equals(this.restriction, that.restriction) && Objects.equals(this.filter, that.filter) && Objects.equals(this.poolSize, that.poolSize) && Objects.equals(this.administratorId, that.administratorId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.ldapHost, this.principal, this.credentials, this.userBase, this.userIdAttribute, this.userObjectClass, this.connectionTimeout, this.readTimeout, this.supportsVirtualHosting, this.restriction, this.filter, this.administratorId, this.poolSize);
    }

    public static class Builder {
        private Optional<String> ldapHost = Optional.empty();
        private Optional<String> principal = Optional.empty();
        private Optional<String> credentials = Optional.empty();
        private Optional<String> userBase = Optional.empty();
        private Optional<String> userIdAttribute = Optional.empty();
        private Optional<String> userObjectClass = Optional.empty();
        private Optional<Integer> poolSize = Optional.empty();

        public Builder ldapHost(String ldapHost) {
            this.ldapHost = Optional.of(ldapHost);
            return this;
        }

        public Builder principal(String principal) {
            this.principal = Optional.of(principal);
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = Optional.of(credentials);
            return this;
        }

        public Builder userBase(String userBase) {
            this.userBase = Optional.of(userBase);
            return this;
        }

        public Builder userIdAttribute(String userIdAttribute) {
            this.userIdAttribute = Optional.of(userIdAttribute);
            return this;
        }

        public Builder userObjectClass(String userObjectClass) {
            this.userObjectClass = Optional.of(userObjectClass);
            return this;
        }

        public Builder poolSize(int poolSize) {
            this.poolSize = Optional.of(poolSize);
            return this;
        }

        public LdapRepositoryConfiguration build() throws ConfigurationException {
            Preconditions.checkState((boolean)this.ldapHost.isPresent(), (Object)"'ldapHost' is mandatory");
            Preconditions.checkState((boolean)this.principal.isPresent(), (Object)"'principal' is mandatory");
            Preconditions.checkState((boolean)this.credentials.isPresent(), (Object)"'credentials' is mandatory");
            Preconditions.checkState((boolean)this.userBase.isPresent(), (Object)"'userBase' is mandatory");
            Preconditions.checkState((boolean)this.userIdAttribute.isPresent(), (Object)"'userIdAttribute' is mandatory");
            Preconditions.checkState((boolean)this.userObjectClass.isPresent(), (Object)"'userObjectClass' is mandatory");
            return new LdapRepositoryConfiguration(this.ldapHost.get(), this.principal.get(), this.credentials.get(), this.userBase.get(), this.userIdAttribute.get(), this.userObjectClass.get(), 0, 0, false, this.poolSize.orElse(4), NO_RESTRICTION, NO_FILTER, NO_ADMINISTRATOR_ID);
        }
    }
}

