/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import reactor.rabbitmq.RabbitFluxException;
import reactor.rabbitmq.RabbitFluxRetryTimeoutException;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.Sender;

public class ExceptionHandlers {
    public static Predicate<Throwable> CONNECTION_RECOVERY_PREDICATE = new ConnectionRecoveryTriggeringPredicate();

    public static class RetrySendingExceptionHandler
    implements BiConsumer<Sender.SendContext, Exception> {
        private final SimpleRetryTemplate retryTemplate;

        public RetrySendingExceptionHandler(Duration timeout, Duration waitingTime, Predicate<Throwable> predicate) {
            this(timeout, waitingTime, predicate, true);
        }

        public RetrySendingExceptionHandler(Duration timeout, Duration waitingTime, Predicate<Throwable> predicate, boolean failOnTimeout) {
            this.retryTemplate = new SimpleRetryTemplate(timeout, waitingTime, predicate, failOnTimeout);
        }

        @Override
        public void accept(Sender.SendContext sendContext, Exception e) {
            this.retryTemplate.retry(() -> {
                sendContext.publish();
                return null;
            }, e);
        }
    }

    public static class RetryAcknowledgmentExceptionHandler
    implements BiConsumer<Receiver.AcknowledgmentContext, Exception> {
        private final SimpleRetryTemplate retryTemplate;

        public RetryAcknowledgmentExceptionHandler(Duration timeout, Duration waitingTime, Predicate<Throwable> predicate) {
            this.retryTemplate = new SimpleRetryTemplate(timeout, waitingTime, predicate, false);
        }

        @Override
        public void accept(Receiver.AcknowledgmentContext acknowledgmentContext, Exception e) {
            this.retryTemplate.retry(() -> {
                acknowledgmentContext.ackOrNack();
                return null;
            }, e);
        }
    }

    public static class SimpleRetryTemplate {
        private final long timeout;
        private final long waitingTime;
        private final Predicate<Throwable> predicate;
        private boolean failOnTimeout;

        public SimpleRetryTemplate(Duration timeout, Duration waitingTime, Predicate<Throwable> predicate) {
            this(timeout, waitingTime, predicate, true);
        }

        public SimpleRetryTemplate(Duration timeout, Duration waitingTime, Predicate<Throwable> predicate, boolean failOnTimeout) {
            if (timeout == null || timeout.isNegative() || timeout.isZero()) {
                throw new IllegalArgumentException("Timeout must be greater than 0");
            }
            if (waitingTime == null || timeout.isNegative() || timeout.isNegative()) {
                throw new IllegalArgumentException("Waiting time must be greater than 0");
            }
            if (timeout.compareTo(waitingTime) <= 0) {
                throw new IllegalArgumentException("Timeout must be greater than waiting time");
            }
            if (predicate == null) {
                throw new NullPointerException("Predicate cannot be null");
            }
            this.timeout = timeout.toMillis();
            this.waitingTime = waitingTime.toMillis();
            this.predicate = predicate;
            this.failOnTimeout = failOnTimeout;
        }

        public void retry(Callable<Void> operation, Exception e) {
            if (this.predicate.test(e)) {
                int elapsedTime = 0;
                boolean callSucceeded = false;
                while ((long)elapsedTime < this.timeout) {
                    try {
                        Thread.sleep(this.waitingTime);
                    }
                    catch (InterruptedException ie) {
                        throw new RabbitFluxException("Thread interrupted while retry on sending", e);
                    }
                    elapsedTime = (int)((long)elapsedTime + this.waitingTime);
                    try {
                        operation.call();
                        callSucceeded = true;
                        break;
                    }
                    catch (Throwable sendingException) {
                        if (this.predicate.test(sendingException)) continue;
                        throw new RabbitFluxException("Not retryable exception thrown during retry", sendingException);
                    }
                }
                if (!callSucceeded && this.failOnTimeout) {
                    throw new RabbitFluxRetryTimeoutException("Retry timed out after " + this.timeout + " ms", e);
                }
            } else {
                throw new RabbitFluxException("Not retryable exception, cannot retry", e);
            }
        }
    }

    public static class ExceptionPredicate
    implements Predicate<Throwable> {
        private final Map<Class<? extends Throwable>, Boolean> retryableExceptions;

        public ExceptionPredicate(Map<Class<? extends Throwable>, Boolean> retryableExceptions) {
            this.retryableExceptions = retryableExceptions;
        }

        @Override
        public boolean test(Throwable throwable) {
            for (Map.Entry<Class<? extends Throwable>, Boolean> retryableException : this.retryableExceptions.entrySet()) {
                if (!retryableException.getKey().isAssignableFrom(throwable.getClass()) || !retryableException.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    public static class ConnectionRecoveryTriggeringPredicate
    implements Predicate<Throwable> {
        @Override
        public boolean test(Throwable throwable) {
            if (throwable instanceof ShutdownSignalException) {
                ShutdownSignalException sse = (ShutdownSignalException)throwable;
                return AutorecoveringConnection.DEFAULT_CONNECTION_RECOVERY_TRIGGERING_CONDITION.test(sse);
            }
            return false;
        }
    }
}

