/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.james.jmap.draft.exceptions.MalformedContinuationTokenException;
import org.apache.james.jmap.draft.model.ContinuationToken;

@JsonDeserialize(builder=Builder.class)
public class AccessTokenRequest {
    public static final String UNIQUE_JSON_PATH = "/token";
    private final ContinuationToken token;
    private final String method;
    private final String password;

    public static Builder builder() {
        return new Builder();
    }

    private AccessTokenRequest(ContinuationToken token, String method, String password) {
        this.token = token;
        this.method = method;
        this.password = password;
    }

    public ContinuationToken getToken() {
        return this.token;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPassword() {
        return this.password;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private ContinuationToken token;
        private String method;
        private String password;

        private Builder() {
        }

        public Builder token(String token) throws MalformedContinuationTokenException {
            this.token = ContinuationToken.fromString(token);
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public AccessTokenRequest build() {
            return new AccessTokenRequest(this.token, this.method, this.password);
        }
    }
}

