/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.refresh;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.schema.events.AggregateChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.FunctionChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.KeyspaceChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TableChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TypeChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.ViewChangeEvent;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SchemaRefresh
implements MetadataRefresh {
    @VisibleForTesting
    public final Map<CqlIdentifier, KeyspaceMetadata> newKeyspaces;

    public SchemaRefresh(Map<CqlIdentifier, KeyspaceMetadata> newKeyspaces) {
        this.newKeyspaces = newKeyspaces;
    }

    @Override
    public MetadataRefresh.Result compute(DefaultMetadata oldMetadata, boolean tokenMapEnabled, InternalDriverContext context) {
        ImmutableList.Builder events = ImmutableList.builder();
        Map<CqlIdentifier, KeyspaceMetadata> oldKeyspaces = oldMetadata.getKeyspaces();
        for (CqlIdentifier cqlIdentifier : Sets.difference(oldKeyspaces.keySet(), this.newKeyspaces.keySet())) {
            events.add((Object)KeyspaceChangeEvent.dropped(oldKeyspaces.get(cqlIdentifier)));
        }
        for (Map.Entry entry : this.newKeyspaces.entrySet()) {
            CqlIdentifier key = (CqlIdentifier)entry.getKey();
            this.computeEvents(oldKeyspaces.get(key), (KeyspaceMetadata)entry.getValue(), (ImmutableList.Builder<Object>)events);
        }
        return new MetadataRefresh.Result(oldMetadata.withSchema(this.newKeyspaces, tokenMapEnabled, context), (List<Object>)events.build());
    }

    private void computeEvents(KeyspaceMetadata oldKeyspace, KeyspaceMetadata newKeyspace, ImmutableList.Builder<Object> events) {
        if (oldKeyspace == null) {
            events.add((Object)KeyspaceChangeEvent.created(newKeyspace));
        } else {
            if (!oldKeyspace.shallowEquals(newKeyspace)) {
                events.add((Object)KeyspaceChangeEvent.updated(oldKeyspace, newKeyspace));
            }
            this.computeChildEvents(oldKeyspace, newKeyspace, events);
        }
    }

    private void computeChildEvents(KeyspaceMetadata oldKeyspace, KeyspaceMetadata newKeyspace, ImmutableList.Builder<Object> events) {
        this.computeChildEvents(oldKeyspace.getTables(), newKeyspace.getTables(), TableChangeEvent::dropped, TableChangeEvent::created, TableChangeEvent::updated, events);
        this.computeChildEvents(oldKeyspace.getViews(), newKeyspace.getViews(), ViewChangeEvent::dropped, ViewChangeEvent::created, ViewChangeEvent::updated, events);
        this.computeChildEvents(oldKeyspace.getUserDefinedTypes(), newKeyspace.getUserDefinedTypes(), TypeChangeEvent::dropped, TypeChangeEvent::created, TypeChangeEvent::updated, events);
        this.computeChildEvents(oldKeyspace.getFunctions(), newKeyspace.getFunctions(), FunctionChangeEvent::dropped, FunctionChangeEvent::created, FunctionChangeEvent::updated, events);
        this.computeChildEvents(oldKeyspace.getAggregates(), newKeyspace.getAggregates(), AggregateChangeEvent::dropped, AggregateChangeEvent::created, AggregateChangeEvent::updated, events);
    }

    private <K, V> void computeChildEvents(Map<K, V> oldChildren, Map<K, V> newChildren, Function<V, Object> newDroppedEvent, Function<V, Object> newCreatedEvent, BiFunction<V, V, Object> newUpdatedEvent, ImmutableList.Builder<Object> events) {
        for (Object e : Sets.difference(oldChildren.keySet(), newChildren.keySet())) {
            events.add(newDroppedEvent.apply(oldChildren.get(e)));
        }
        for (Map.Entry entry : newChildren.entrySet()) {
            Object key = entry.getKey();
            Object newChild = entry.getValue();
            V oldChild = oldChildren.get(key);
            if (oldChild == null) {
                events.add(newCreatedEvent.apply(newChild));
                continue;
            }
            if (oldChild.equals(newChild)) continue;
            events.add(newUpdatedEvent.apply(oldChild, newChild));
        }
    }
}

