/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.identity;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityUpdate;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.EmailerName;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.Identity$;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.api.model.IdentityId$;
import org.apache.james.jmap.cassandra.identity.CassandraCustomIdentityDAO$;
import org.apache.james.jmap.cassandra.identity.tables.CassandraCustomIdentityTable$;
import org.apache.james.jmap.cassandra.identity.tables.CassandraCustomIdentityTable$EmailAddress$;
import org.apache.james.jmap.cassandra.utils.EmailAddressTupleUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%a\u0001\u0002\u001a4\u0001\u0002C\u0001\"\u0018\u0001\u0003\u0016\u0004%\tA\u0018\u0005\t]\u0002\u0011\t\u0012)A\u0005?\"Aq\u000e\u0001BK\u0002\u0013\u0005\u0001\u000f\u0003\u0005{\u0001\tE\t\u0015!\u0003r\u0011\u0015Y\b\u0001\"\u0001}\u0011%\t)\u0002\u0001b\u0001\n\u0003\t9\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\r\u0011%\t9\u0003\u0001b\u0001\n\u0003\tI\u0003\u0003\u0005\u00026\u0001\u0001\u000b\u0011BA\u0016\u0011%\t9\u0004\u0001b\u0001\n\u0003\tI\u0004\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u001e\u0011%\tI\u0005\u0001b\u0001\n\u0003\tI\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u001e\u0011%\ti\u0005\u0001b\u0001\n\u0003\tI\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001e\u0011%\t\t\u0006\u0001b\u0001\n\u0003\tI\u0004\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA\u001e\u0011\u001d\t)\u0006\u0001C!\u0003/Bq!!\u0016\u0001\t\u0003\n\t\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\b\u00033\u0004A\u0011IAn\u0011\u001d\tY\u000f\u0001C\u0005\u0003[Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\te\u0001\u0001\"\u0003\u0003\u001c!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\n\u0005\u0017\u0002\u0011\u0011!C\u0001\u0005\u001bB\u0011Ba\u0015\u0001#\u0003%\tA!\u0016\t\u0013\t-\u0004!%A\u0005\u0002\t5\u0004\"\u0003B9\u0001\u0005\u0005I\u0011\tB:\u0011%\u0011\t\tAA\u0001\n\u0003\u0011\u0019\tC\u0005\u0003\f\u0002\t\t\u0011\"\u0001\u0003\u000e\"I!\u0011\u0014\u0001\u0002\u0002\u0013\u0005#1\u0014\u0005\n\u0005S\u0003\u0011\u0011!C\u0001\u0005WC\u0011B!.\u0001\u0003\u0003%\tEa.\t\u0013\tm\u0006!!A\u0005B\tu\u0006\"\u0003B`\u0001\u0005\u0005I\u0011\tBa\u0011%\u0011\u0019\rAA\u0001\n\u0003\u0012)mB\u0005\u0003JN\n\t\u0011#\u0001\u0003L\u001aA!gMA\u0001\u0012\u0003\u0011i\r\u0003\u0004|Y\u0011\u0005!Q\u001d\u0005\n\u0005\u007fc\u0013\u0011!C#\u0005\u0003D\u0011Ba:-\u0003\u0003%\tI!;\t\u0013\t=H&!A\u0005\u0002\nE\b\"\u0003B\u0000Y\u0005\u0005I\u0011BB\u0001\u0005i\u0019\u0015m]:b]\u0012\u0014\u0018mQ;ti>l\u0017\nZ3oi&$\u0018\u0010R!P\u0015\t!T'\u0001\u0005jI\u0016tG/\u001b;z\u0015\t1t'A\u0005dCN\u001c\u0018M\u001c3sC*\u0011\u0001(O\u0001\u0005U6\f\u0007O\u0003\u0002;w\u0005)!.Y7fg*\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h\u0007\u0001\u0019R\u0001A!H\u001dF\u0003\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013a!\u00118z%\u00164\u0007C\u0001%M\u001b\u0005I%B\u0001\u001bK\u0015\tYu'A\u0002ba&L!!T%\u0003#\r+8\u000f^8n\u0013\u0012,g\u000e^5us\u0012\u000bu\n\u0005\u0002C\u001f&\u0011\u0001k\u0011\u0002\b!J|G-^2u!\t\u0011&L\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011akP\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!!W\"\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u00033\u000e\u000bqa]3tg&|g.F\u0001`!\t\u0001G.D\u0001b\u0015\t\u00117-\u0001\u0003d_J,'BA&e\u0015\t)g-\u0001\u0004ee&4XM\u001d\u0006\u0003O\"\f1a\\:t\u0015\tI'.\u0001\u0005eCR\f7\u000f^1y\u0015\u0005Y\u0017aA2p[&\u0011Q.\u0019\u0002\u000b\u0007Fd7+Z:tS>t\u0017\u0001C:fgNLwN\u001c\u0011\u0002\u001bQL\b/Z:Qe>4\u0018\u000eZ3s+\u0005\t\bC\u0001:y\u001b\u0005\u0019(B\u0001;v\u0003\u0011Ig.\u001b;\u000b\u0005Y2(BA<:\u0003!\u0011\u0017mY6f]\u0012\u001c\u0018BA=t\u0005Y\u0019\u0015m]:b]\u0012\u0014\u0018\rV=qKN\u0004&o\u001c<jI\u0016\u0014\u0018A\u0004;za\u0016\u001c\bK]8wS\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tu|\u0018\u0011\u0001\t\u0003}\u0002i\u0011a\r\u0005\u0006;\u0016\u0001\ra\u0018\u0005\u0006_\u0016\u0001\r!\u001d\u0015\u0004\u000b\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007S:TWm\u0019;\u000b\u0005\u0005=\u0011!\u00026bm\u0006D\u0018\u0002BA\n\u0003\u0013\u0011a!\u00138kK\u000e$\u0018\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}Q/A\u0003vi&d7/\u0003\u0003\u0002$\u0005u!AF\"bgN\fg\u000e\u001a:b\u0003NLhnY#yK\u000e,Ho\u001c:\u0002\u0013\u0015DXmY;u_J\u0004\u0013!F3nC&d\u0017\t\u001a3sKN\u001cH+\u001e9mKV#\u0018\u000e\\\u000b\u0003\u0003W\u0001B!!\f\u000225\u0011\u0011q\u0006\u0006\u0004\u0003?)\u0014\u0002BA\u001a\u0003_\u0011Q#R7bS2\fE\r\u001a:fgN$V\u000f\u001d7f+RLG.\u0001\ff[\u0006LG.\u00113ee\u0016\u001c8\u000fV;qY\u0016,F/\u001b7!\u0003=Ign]3siN#\u0018\r^3nK:$XCAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!C\u0006\u00191-\u001d7\n\t\u0005\u0015\u0013q\b\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\u0018\u0001E5og\u0016\u0014Ho\u0015;bi\u0016lWM\u001c;!\u0003I\u0019X\r\\3di\u0006cGn\u0015;bi\u0016lWM\u001c;\u0002'M,G.Z2u\u00032d7\u000b^1uK6,g\u000e\u001e\u0011\u0002%M,G.Z2u\u001f:,7\u000b^1uK6,g\u000e^\u0001\u0014g\u0016dWm\u0019;P]\u0016\u001cF/\u0019;f[\u0016tG\u000fI\u0001\u0013I\u0016dW\r^3P]\u0016\u001cF/\u0019;f[\u0016tG/A\neK2,G/Z(oKN#\u0018\r^3nK:$\b%\u0001\u0003tCZ,GCBA-\u0003s\n9\t\u0005\u0004\u0002\\\u0005%\u0014QN\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0004\t\u0006\r$b\u00012\u0002f)\u0011\u0011qM\u0001\be\u0016\f7\r^8s\u0013\u0011\tY'!\u0018\u0003\u000bMkuN\\8\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dK\u0003\u0015iw\u000eZ3m\u0013\u0011\t9(!\u001d\u0003\u0011%#WM\u001c;jifDq!a\u001f\u0013\u0001\u0004\ti(\u0001\u0003vg\u0016\u0014\b\u0003BA@\u0003\u0007k!!!!\u000b\u0005\tL\u0014\u0002BAC\u0003\u0003\u0013\u0001\"V:fe:\fW.\u001a\u0005\b\u0003\u0013\u0013\u0002\u0019AAF\u0003=\u0019'/Z1uS>t'+Z9vKN$\bc\u0001%\u0002\u000e&\u0019\u0011qR%\u0003/%#WM\u001c;jif\u001c%/Z1uS>t'+Z9vKN$H\u0003CA-\u0003'\u000b)*a(\t\u000f\u0005m4\u00031\u0001\u0002~!9\u0011qS\nA\u0002\u0005e\u0015AC5eK:$\u0018\u000e^=JIB!\u0011qNAN\u0013\u0011\ti*!\u001d\u0003\u0015%#WM\u001c;jifLE\rC\u0004\u0002\nN\u0001\r!a#\u0002\t1L7\u000f\u001e\u000b\u0005\u0003K\u000bY\u000b\u0005\u0004\u0002\\\u0005\u001d\u0016QN\u0005\u0005\u0003S\u000biFA\u0003T\r2,\b\u0010C\u0004\u0002|Q\u0001\r!! \u0002!\u0019Lg\u000e\u001a\"z\u0013\u0012,g\u000e^5us&#GCBA-\u0003c\u000b\u0019\fC\u0004\u0002|U\u0001\r!! \t\u000f\u0005]U\u00031\u0001\u0002\u001a\u00061Q\u000f\u001d3bi\u0016$\u0002\"!/\u0002B\u0006\r\u0017Q\u0019\t\u0007\u00037\nI'a/\u0011\u0007\t\u000bi,C\u0002\u0002@\u000e\u0013A!\u00168ji\"9\u00111\u0010\fA\u0002\u0005u\u0004bBAL-\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003\u000f4\u0002\u0019AAe\u00039IG-\u001a8uSRLX\u000b\u001d3bi\u0016\u00042\u0001SAf\u0013\r\ti-\u0013\u0002\u000f\u0013\u0012,g\u000e^5usV\u0003H-\u0019;f\u0003\u0019)\bo]3siR1\u0011\u0011XAj\u0003+Dq!a\u001f\u0018\u0001\u0004\ti\bC\u0004\u0002X^\u0001\r!!\u001c\u0002\u000bA\fGo\u00195\u0002\r\u0011,G.\u001a;f)\u0019\tI,!8\u0002b\"9\u0011q\u001c\rA\u0002\u0005u\u0014\u0001C;tKJt\u0017-\\3\t\u000f\u0005\r\b\u00041\u0001\u0002f\u0006\u0019\u0011\u000eZ:\u0011\u000bI\u000b9/!'\n\u0007\u0005%HLA\u0002TKF\fa!\u001b8tKJ$HCBA-\u0003_\f\t\u0010C\u0004\u0002`f\u0001\r!! \t\rQJ\u0002\u0019AA7\u0003)!x.\u00133f]RLG/\u001f\u000b\u0005\u0003[\n9\u0010C\u0004\u0002zj\u0001\r!a?\u0002\u0007I|w\u000f\u0005\u0003\u0002>\u0005u\u0018\u0002BA\u0000\u0003\u007f\u00111AU8x\u0003%!xNU3qYf$v\u000e\u0006\u0003\u0003\u0006\t]\u0001#\u0002\"\u0003\b\t-\u0011b\u0001B\u0005\u0007\n1q\n\u001d;j_:\u0004RA\u0015B\u0007\u0005#I1Aa\u0004]\u0005\u0011a\u0015n\u001d;\u0011\t\u0005=$1C\u0005\u0005\u0005+\t\tH\u0001\u0007F[\u0006LG.\u00113ee\u0016\u001c8\u000fC\u0004\u0002zn\u0001\r!a?\u0002\u000bQ|'iY2\u0015\t\t\u0015!Q\u0004\u0005\b\u0003sd\u0002\u0019AA~\u0003%!xNS1wCN+G\u000f\u0006\u0003\u0003$\t}\u0002C\u0002B\u0013\u0005_\u0011\u0019$\u0004\u0002\u0003()!!\u0011\u0006B\u0016\u0003\u0011)H/\u001b7\u000b\u0005\t5\u0012\u0001\u00026bm\u0006LAA!\r\u0003(\t\u00191+\u001a;\u0011\t\tU\"1H\u0007\u0003\u0005oQ1A!\u000fb\u0003\u0011!\u0017\r^1\n\t\tu\"q\u0007\u0002\t+\u0012$h+\u00197vK\"9!\u0011I\u000fA\u0002\t-\u0011\u0001\u00057jgR,U.Y5m\u0003\u0012$'/Z:t\u00039!x.R7bS2\fE\r\u001a:fgN$BA!\u0005\u0003H!9!\u0011\n\u0010A\u0002\tM\u0012\u0001C;eiZ\u000bG.^3\u0002\t\r|\u0007/\u001f\u000b\u0006{\n=#\u0011\u000b\u0005\b;~\u0001\n\u00111\u0001`\u0011\u001dyw\u0004%AA\u0002E\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003X)\u001aqL!\u0017,\u0005\tm\u0003\u0003\u0002B/\u0005Oj!Aa\u0018\u000b\t\t\u0005$1M\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001aD\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005S\u0012yFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003p)\u001a\u0011O!\u0017\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\b\u0005\u0003\u0003x\tuTB\u0001B=\u0015\u0011\u0011YHa\u000b\u0002\t1\fgnZ\u0005\u0005\u0005\u007f\u0012IH\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u000b\u00032A\u0011BD\u0013\r\u0011Ii\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001f\u0013)\nE\u0002C\u0005#K1Aa%D\u0005\r\te.\u001f\u0005\n\u0005/#\u0013\u0011!a\u0001\u0005\u000b\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BO!\u0019\u0011yJ!*\u0003\u00106\u0011!\u0011\u0015\u0006\u0004\u0005G\u001b\u0015AC2pY2,7\r^5p]&!!q\u0015BQ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t5&1\u0017\t\u0004\u0005\n=\u0016b\u0001BY\u0007\n9!i\\8mK\u0006t\u0007\"\u0003BLM\u0005\u0005\t\u0019\u0001BH\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tU$\u0011\u0018\u0005\n\u0005/;\u0013\u0011!a\u0001\u0005\u000b\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005k\na!Z9vC2\u001cH\u0003\u0002BW\u0005\u000fD\u0011Ba&+\u0003\u0003\u0005\rAa$\u00025\r\u000b7o]1oIJ\f7)^:u_6LE-\u001a8uSRLH)Q(\u0011\u0005yd3#\u0002\u0017\u0003P\nm\u0007c\u0002Bi\u0005/|\u0016/`\u0007\u0003\u0005'T1A!6D\u0003\u001d\u0011XO\u001c;j[\u0016LAA!7\u0003T\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\tu'1]\u0007\u0003\u0005?TAA!9\u0003,\u0005\u0011\u0011n\\\u0005\u00047\n}GC\u0001Bf\u0003\u0015\t\u0007\u000f\u001d7z)\u0015i(1\u001eBw\u0011\u0015iv\u00061\u0001`\u0011\u0015yw\u00061\u0001r\u0003\u001d)h.\u00199qYf$BAa=\u0003|B)!Ia\u0002\u0003vB)!Ia>`c&\u0019!\u0011`\"\u0003\rQ+\b\u000f\\33\u0011!\u0011i\u0010MA\u0001\u0002\u0004i\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u001111\u0001\t\u0005\u0005o\u001a)!\u0003\u0003\u0004\b\te$AB(cU\u0016\u001cG\u000f")
public class CassandraCustomIdentityDAO
implements CustomIdentityDAO,
Product,
Serializable {
    private final CqlSession session;
    private final CassandraTypesProvider typesProvider;
    private final CassandraAsyncExecutor executor;
    private final EmailAddressTupleUtil emailAddressTupleUtil;
    private final PreparedStatement insertStatement;
    private final PreparedStatement selectAllStatement;
    private final PreparedStatement selectOneStatement;
    private final PreparedStatement deleteOneStatement;

    public static Option<Tuple2<CqlSession, CassandraTypesProvider>> unapply(CassandraCustomIdentityDAO x$0) {
        return CassandraCustomIdentityDAO$.MODULE$.unapply(x$0);
    }

    public static CassandraCustomIdentityDAO apply(CqlSession session, CassandraTypesProvider typesProvider) {
        return CassandraCustomIdentityDAO$.MODULE$.apply(session, typesProvider);
    }

    public static Function1<Tuple2<CqlSession, CassandraTypesProvider>, CassandraCustomIdentityDAO> tupled() {
        return CassandraCustomIdentityDAO$.MODULE$.tupled();
    }

    public static Function1<CqlSession, Function1<CassandraTypesProvider, CassandraCustomIdentityDAO>> curried() {
        return CassandraCustomIdentityDAO$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public CqlSession session() {
        return this.session;
    }

    public CassandraTypesProvider typesProvider() {
        return this.typesProvider;
    }

    public CassandraAsyncExecutor executor() {
        return this.executor;
    }

    public EmailAddressTupleUtil emailAddressTupleUtil() {
        return this.emailAddressTupleUtil;
    }

    public PreparedStatement insertStatement() {
        return this.insertStatement;
    }

    public PreparedStatement selectAllStatement() {
        return this.selectAllStatement;
    }

    public PreparedStatement selectOneStatement() {
        return this.selectOneStatement;
    }

    public PreparedStatement deleteOneStatement() {
        return this.deleteOneStatement;
    }

    public SMono<Identity> save(Username user, IdentityCreationRequest creationRequest) {
        return this.save(user, IdentityId$.MODULE$.generate(), creationRequest);
    }

    public SMono<Identity> save(Username user, IdentityId identityId, IdentityCreationRequest creationRequest) {
        return SMono$.MODULE$.just((Object)identityId).map((Function1 & Serializable)id -> creationRequest.asIdentity(id)).flatMap((Function1 & Serializable)identity -> this.insert(user, (Identity)identity));
    }

    public SFlux<Identity> list(Username user) {
        return SFlux$.MODULE$.fromPublisher((Publisher)this.executor().executeRows((Statement)this.selectAllStatement().bind(new Object[0]).setString(CassandraCustomIdentityTable$.MODULE$.USER(), user.asString())).map(row -> this.toIdentity((Row)row)));
    }

    public SMono<Identity> findByIdentityId(Username user, IdentityId identityId) {
        return SMono$.MODULE$.fromPublisher((Publisher)this.executor().executeSingleRow((Statement)this.selectOneStatement().bind(new Object[0]).setString(CassandraCustomIdentityTable$.MODULE$.USER(), user.asString()).setUuid(CassandraCustomIdentityTable$.MODULE$.ID(), identityId.id())).map(row -> this.toIdentity((Row)row)));
    }

    public SMono<BoxedUnit> update(Username user, IdentityId identityId, IdentityUpdate identityUpdate) {
        return SMono$.MODULE$.fromPublisher((Publisher)this.executor().executeSingleRow((Statement)this.selectOneStatement().bind(new Object[0]).setString(CassandraCustomIdentityTable$.MODULE$.USER(), user.asString()).setUuid(CassandraCustomIdentityTable$.MODULE$.ID(), identityId.id())).switchIfEmpty(Mono.error(() -> new IdentityNotFoundException(identityId))).map(row -> this.toIdentity((Row)row)).map(x$1 -> identityUpdate.update(x$1)).flatMap(patch -> this.insert(user, (Identity)patch).then().asJava()));
    }

    public SMono<BoxedUnit> upsert(Username user, Identity patch) {
        return this.insert(user, patch).then();
    }

    public SMono<BoxedUnit> delete(Username username, Seq<IdentityId> ids) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(ids);
        Function1 & Serializable x$1 = (Function1 & Serializable)id -> this.executor().executeVoid((Statement)this.deleteOneStatement().bind(new Object[0]).setString(CassandraCustomIdentityTable$.MODULE$.USER(), username.asString()).setUuid(CassandraCustomIdentityTable$.MODULE$.ID(), id.id()));
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).then();
    }

    private SMono<Identity> insert(Username username, Identity identity) {
        java.util.Set<UdtValue> replyTo = this.toJavaSet((List<EmailAddress>)((List)identity.replyTo().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)));
        java.util.Set<UdtValue> bcc = this.toJavaSet((List<EmailAddress>)((List)identity.bcc().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)));
        BoundStatement insertIdentity = (BoundStatement)this.insertStatement().bind(new Object[0]).setString(CassandraCustomIdentityTable$.MODULE$.USER(), username.asString()).setUuid(CassandraCustomIdentityTable$.MODULE$.ID(), identity.id().id()).setString(CassandraCustomIdentityTable$.MODULE$.NAME(), identity.name()).setString(CassandraCustomIdentityTable$.MODULE$.EMAIL(), identity.email().asString()).setString(CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE(), identity.textSignature()).setString(CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE(), identity.htmlSignature()).setBoolean(CassandraCustomIdentityTable$.MODULE$.MAY_DELETE(), identity.mayDelete()).setInt(CassandraCustomIdentityTable$.MODULE$.SORT_ORDER(), identity.sortOrder()).setSet(CassandraCustomIdentityTable$.MODULE$.REPLY_TO(), replyTo, UdtValue.class).setSet(CassandraCustomIdentityTable$.MODULE$.BCC(), bcc, UdtValue.class);
        return SMono$.MODULE$.fromPublisher((Publisher)this.executor().executeVoid((Statement)insertIdentity).thenReturn((Object)identity));
    }

    private Identity toIdentity(Row row) {
        IdentityId x$1 = new IdentityId(row.getUuid(CassandraCustomIdentityTable$.MODULE$.ID()));
        String x$2 = row.getString(CassandraCustomIdentityTable$.MODULE$.NAME());
        MailAddress x$3 = new MailAddress(row.getString(CassandraCustomIdentityTable$.MODULE$.EMAIL()));
        Option<List<EmailAddress>> x$4 = this.toReplyTo(row);
        Option<List<EmailAddress>> x$5 = this.toBcc(row);
        String x$6 = row.getString(CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE());
        String x$7 = row.getString(CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE());
        boolean x$8 = row.getBoolean(CassandraCustomIdentityTable$.MODULE$.MAY_DELETE());
        int x$9 = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)row.getInt(CassandraCustomIdentityTable$.MODULE$.SORT_ORDER()))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Identity$.MODULE$.DEFAULT_SORTORDER()));
        return new Identity(x$1, x$9, x$2, x$3, x$4, x$5, x$6, x$7, x$8);
    }

    private Option<List<EmailAddress>> toReplyTo(Row row) {
        return Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.asScala(row.getSet(CassandraCustomIdentityTable$.MODULE$.REPLY_TO(), UdtValue.class)).toList().map((Function1 & Serializable)udtValue -> this.toEmailAddress((UdtValue)udtValue)));
    }

    private Option<List<EmailAddress>> toBcc(Row row) {
        return Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.asScala(row.getSet(CassandraCustomIdentityTable$.MODULE$.BCC(), UdtValue.class)).toList().map((Function1 & Serializable)udtValue -> this.toEmailAddress((UdtValue)udtValue)));
    }

    private java.util.Set<UdtValue> toJavaSet(List<EmailAddress> listEmailAddress) {
        return CollectionConverters$.MODULE$.asJava((Set)listEmailAddress.map((Function1 & Serializable)emailAddress -> this.emailAddressTupleUtil().createEmailAddressUDT((Option<String>)emailAddress.name().map((Function1 & Serializable)name -> ((EmailerName)name).value()), emailAddress.email().asString())).toSet());
    }

    private EmailAddress toEmailAddress(UdtValue udtValue) {
        return new EmailAddress(Option$.MODULE$.apply((Object)udtValue.getString(CassandraCustomIdentityTable$EmailAddress$.MODULE$.NAME())).map((Function1 & Serializable)string -> new EmailerName(string)), new MailAddress(udtValue.getString(CassandraCustomIdentityTable$EmailAddress$.MODULE$.EMAIL())));
    }

    public CassandraCustomIdentityDAO copy(CqlSession session, CassandraTypesProvider typesProvider) {
        return new CassandraCustomIdentityDAO(session, typesProvider);
    }

    public CqlSession copy$default$1() {
        return this.session();
    }

    public CassandraTypesProvider copy$default$2() {
        return this.typesProvider();
    }

    public String productPrefix() {
        return "CassandraCustomIdentityDAO";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.session();
            }
            case 1: {
                return this.typesProvider();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CassandraCustomIdentityDAO;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "session";
            }
            case 1: {
                return "typesProvider";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CassandraCustomIdentityDAO)) return false;
        boolean bl = true;
        if (!bl) return false;
        CassandraCustomIdentityDAO cassandraCustomIdentityDAO = (CassandraCustomIdentityDAO)x$1;
        CqlSession cqlSession = this.session();
        CqlSession cqlSession2 = cassandraCustomIdentityDAO.session();
        if (cqlSession == null) {
            if (cqlSession2 != null) {
                return false;
            }
        } else if (!cqlSession.equals(cqlSession2)) return false;
        CassandraTypesProvider cassandraTypesProvider = this.typesProvider();
        CassandraTypesProvider cassandraTypesProvider2 = cassandraCustomIdentityDAO.typesProvider();
        if (cassandraTypesProvider == null) {
            if (cassandraTypesProvider2 != null) {
                return false;
            }
        } else if (!cassandraTypesProvider.equals(cassandraTypesProvider2)) return false;
        if (!cassandraCustomIdentityDAO.canEqual(this)) return false;
        return true;
    }

    @Inject
    public CassandraCustomIdentityDAO(CqlSession session, CassandraTypesProvider typesProvider) {
        this.session = session;
        this.typesProvider = typesProvider;
        Product.$init$((Product)this);
        this.executor = new CassandraAsyncExecutor(session);
        this.emailAddressTupleUtil = new EmailAddressTupleUtil(typesProvider);
        this.insertStatement = session.prepare(QueryBuilder.insertInto((String)CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).value(CassandraCustomIdentityTable$.MODULE$.USER(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.USER())).value(CassandraCustomIdentityTable$.MODULE$.ID(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.ID())).value(CassandraCustomIdentityTable$.MODULE$.NAME(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.NAME())).value(CassandraCustomIdentityTable$.MODULE$.EMAIL(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.EMAIL())).value(CassandraCustomIdentityTable$.MODULE$.REPLY_TO(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.REPLY_TO())).value(CassandraCustomIdentityTable$.MODULE$.BCC(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.BCC())).value(CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.TEXT_SIGNATURE())).value(CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.HTML_SIGNATURE())).value(CassandraCustomIdentityTable$.MODULE$.MAY_DELETE(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.MAY_DELETE())).value(CassandraCustomIdentityTable$.MODULE$.SORT_ORDER(), (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.SORT_ORDER())).build());
        this.selectAllStatement = session.prepare(((BuildableQuery)QueryBuilder.selectFrom((String)CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).all().whereColumn(CassandraCustomIdentityTable$.MODULE$.USER()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.USER()))).build());
        this.selectOneStatement = session.prepare(((BuildableQuery)((OngoingWhereClause)QueryBuilder.selectFrom((String)CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).all().whereColumn(CassandraCustomIdentityTable$.MODULE$.USER()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.USER()))).whereColumn(CassandraCustomIdentityTable$.MODULE$.ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.ID()))).build());
        this.deleteOneStatement = session.prepare(((BuildableQuery)((OngoingWhereClause)QueryBuilder.deleteFrom((String)CassandraCustomIdentityTable$.MODULE$.TABLE_NAME()).whereColumn(CassandraCustomIdentityTable$.MODULE$.USER()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.USER()))).whereColumn(CassandraCustomIdentityTable$.MODULE$.ID()).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraCustomIdentityTable$.MODULE$.ID()))).build());
    }
}

