/*
 * Decompiled with CFR 0.152.
 */
package spark.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;

final class FilterTools {
    private static final String SLASH_WILDCARD = "/*";
    private static final String SLASH = "/";
    private static final String FILTER_MAPPING_PARAM = "filterMappingUrlPattern";

    private FilterTools() {
    }

    static String getRelativePath(HttpServletRequest request, String filterPath) {
        String path = request.getRequestURI();
        String contextPath = request.getContextPath();
        if ((path = path.substring(contextPath.length())).length() > 0) {
            path = path.substring(1);
        }
        if (!path.startsWith(filterPath) && filterPath.equals(path + SLASH)) {
            path = path + SLASH;
        }
        if (path.startsWith(filterPath)) {
            path = path.substring(filterPath.length());
        }
        if (!path.startsWith(SLASH)) {
            path = SLASH + path;
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    static String getFilterPath(FilterConfig config) {
        String result = config.getInitParameter(FILTER_MAPPING_PARAM);
        if (result == null || result.equals(SLASH_WILDCARD)) {
            return "";
        }
        if (!result.startsWith(SLASH) || !result.endsWith(SLASH_WILDCARD)) {
            throw new RuntimeException("The filterMappingUrlPattern must start with \"/\" and end with \"/*\". It's: " + result);
        }
        return result.substring(1, result.length() - 1);
    }
}

