/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;

public class RetryBackoffConfiguration {
    static final double DEFAULT_JITTER_FACTOR = 0.5;
    static final int DEFAULT_MAX_RETRIES = 8;
    static final Duration DEFAULT_FIRST_BACKOFF = Duration.ofMillis(100L);
    public static final RetryBackoffConfiguration DEFAULT = new RetryBackoffConfiguration(8, DEFAULT_FIRST_BACKOFF, 0.5);
    private final int maxRetries;
    private final Duration firstBackoff;
    private final double jitterFactor;

    public static RequireMaxRetries builder() {
        return maxRetries -> firstBackoff -> jitterFactor -> new ReadyToBuild(maxRetries, firstBackoff, jitterFactor);
    }

    private RetryBackoffConfiguration(int maxRetries, Duration firstBackoff, double jitterFactor) {
        Preconditions.checkArgument(!firstBackoff.isNegative(), "firstBackoff is not allowed to be negative");
        Preconditions.checkArgument(maxRetries >= 0, "maxRetries is not allowed to be negative");
        Preconditions.checkArgument(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor is not allowed to be negative or greater than 1");
        this.maxRetries = maxRetries;
        this.firstBackoff = firstBackoff;
        this.jitterFactor = jitterFactor;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getFirstBackoff() {
        return this.firstBackoff;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public final boolean equals(Object o) {
        if (o instanceof RetryBackoffConfiguration) {
            RetryBackoffConfiguration that = (RetryBackoffConfiguration)o;
            return Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.jitterFactor, that.jitterFactor) && Objects.equals(this.firstBackoff, that.firstBackoff);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.maxRetries, this.firstBackoff, this.jitterFactor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxRetries", this.maxRetries).add("firstBackoff", this.firstBackoff).add("jitterFactor", this.jitterFactor).toString();
    }

    @FunctionalInterface
    public static interface RequireMaxRetries {
        public RequireFirstBackoff maxRetries(int var1);
    }

    @FunctionalInterface
    public static interface RequireFirstBackoff {
        public RequireJitterFactor firstBackoff(Duration var1);
    }

    @FunctionalInterface
    public static interface RequireJitterFactor {
        public ReadyToBuild jitterFactor(double var1);
    }

    public static class ReadyToBuild {
        private final int maxRetries;
        private final Duration firstBackoff;
        private final double jitterFactor;

        private ReadyToBuild(int maxRetries, Duration firstBackoff, double jitterFactor) {
            this.maxRetries = maxRetries;
            this.firstBackoff = firstBackoff;
            this.jitterFactor = jitterFactor;
        }

        public RetryBackoffConfiguration build() {
            return new RetryBackoffConfiguration(this.maxRetries, this.firstBackoff, this.jitterFactor);
        }
    }
}

