/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.james.events.Event;
import org.apache.james.events.EventSerializer;

@Singleton
public class EventSerializersAggregator
implements EventSerializer {
    private final Set<EventSerializer> allEventSerializers;

    @Inject
    public EventSerializersAggregator(Set<EventSerializer> allEventSerializers) {
        this.allEventSerializers = allEventSerializers;
    }

    @Override
    public String toJson(Event event) {
        return (String)this.allEventSerializers.stream().map(eventSerializer -> this.serialize(event, (EventSerializer)eventSerializer)).flatMap(Optional::stream).findFirst().orElseThrow(() -> new RuntimeException("Could not serialize event: " + String.valueOf(event)));
    }

    @Override
    public Event asEvent(String serialized) {
        return (Event)this.allEventSerializers.stream().map(eventSerializer -> this.deserialize(serialized, (EventSerializer)eventSerializer)).flatMap(Optional::stream).findFirst().orElseThrow(() -> new RuntimeException("Could not deserialize event: " + serialized));
    }

    @Override
    public String toJson(Collection<Event> events) {
        return (String)this.allEventSerializers.stream().map(eventSerializer -> this.serialize(events, (EventSerializer)eventSerializer)).flatMap(Optional::stream).findFirst().orElseThrow(() -> new RuntimeException("Could not serialize event: " + String.valueOf(events)));
    }

    @Override
    public List<Event> asEvents(String serialized) {
        return (List)this.allEventSerializers.stream().map(eventSerializer -> this.deserializeEvents(serialized, (EventSerializer)eventSerializer)).flatMap(Optional::stream).findFirst().orElseThrow(() -> new RuntimeException("Could not deserialize event: " + serialized));
    }

    private Optional<String> serialize(Event event, EventSerializer eventSerializer) {
        try {
            return Optional.of(eventSerializer.toJson(event));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private Optional<String> serialize(Collection<Event> event, EventSerializer eventSerializer) {
        try {
            return Optional.of(eventSerializer.toJson(event));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private Optional<Event> deserialize(String json, EventSerializer eventSerializer) {
        try {
            return Optional.of(eventSerializer.asEvent(json));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private Optional<List<Event>> deserializeEvents(String json, EventSerializer eventSerializer) {
        try {
            return Optional.of(eventSerializer.asEvents(json));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }
}

