/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.impl.ContextPropagation;
import org.apache.pekko.stream.impl.ContextPropagationImpl;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.fusing.GroupedWeightedWithin$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015sAB\f\u0019\u0011\u0003qBE\u0002\u0004'1!\u0005ad\n\u0005\u0006]\u0005!\t\u0001\r\u0005\bc\u0005\u0011\r\u0011\"\u00013\u0011\u0019Y\u0014\u0001)A\u0005g\u0019)a\u0005\u0007\u0002\u001f\t\"A1-\u0002BC\u0002\u0013\u0005A\r\u0003\u0005i\u000b\t\u0005\t\u0015!\u0003f\u0011!IWA!b\u0001\n\u0003Q\u0007\u0002\u00038\u0006\u0005\u0003\u0005\u000b\u0011B6\t\u0011=,!Q1A\u0005\u0002AD\u0001\u0002^\u0003\u0003\u0002\u0003\u0006I!\u001d\u0005\tk\u0016\u0011)\u0019!C\u0001m\"Aq0\u0002B\u0001B\u0003%q\u000f\u0003\u0004/\u000b\u0011\u0005\u0011\u0011\u0001\u0005\n\u0003\u001b)!\u0019!C\u0001\u0003\u001fA\u0001\"a\u0006\u0006A\u0003%\u0011\u0011\u0003\u0005\n\u00033)!\u0019!C\u0001\u00037A\u0001\"a\t\u0006A\u0003%\u0011Q\u0004\u0005\b\u0003K)A\u0011IA\u0014\u0011%\ty#\u0002b\u0001\n\u0003\t\t\u0004C\u0004\u00024\u0015\u0001\u000b\u0011\u0002'\t\u000f\u0005UR\u0001\"\u0011\u00028\u0005)rI]8va\u0016$w+Z5hQR,GmV5uQ&t'BA\r\u001b\u0003\u00191Wo]5oO*\u00111\u0004H\u0001\u0005S6\u0004HN\u0003\u0002\u001e=\u000511\u000f\u001e:fC6T!a\b\u0011\u0002\u000bA,7n[8\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'o\u001a\t\u0003K\u0005i\u0011\u0001\u0007\u0002\u0016\u000fJ|W\u000f]3e/\u0016Lw\r\u001b;fI^KG\u000f[5o'\t\t\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tA%\u0001\u000ehe>,\b/\u001a3XK&<\u0007\u000e^3e/&$\b.\u001b8US6,'/F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012aa\u0015;sS:<\u0017aG4s_V\u0004X\rZ,fS\u001eDG/\u001a3XSRD\u0017N\u001c+j[\u0016\u0014\b\u0005\u000b\u0002\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\"@\u0005-Ie\u000e^3s]\u0006d\u0017\t]5)\u0005\u0001iTCA#S'\t)a\tE\u0002H\u00152k\u0011\u0001\u0013\u0006\u0003\u0013r\tQa\u001d;bO\u0016L!a\u0013%\u0003\u0015\u001d\u0013\u0018\r\u001d5Ti\u0006<W\r\u0005\u0003N\u001dB[V\"\u0001\u000f\n\u0005=c\"!\u0003$m_^\u001c\u0006.\u00199f!\t\t&\u000b\u0004\u0001\u0005\u000bM+!\u0019\u0001+\u0003\u0003Q\u000b\"!\u0016-\u0011\u0005%2\u0016BA,+\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!K-\n\u0005iS#aA!osB\u0019A,\u0019)\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u00131aU3r\u0003%i\u0017\r_,fS\u001eDG/F\u0001f!\tIc-\u0003\u0002hU\t!Aj\u001c8h\u0003)i\u0017\r_,fS\u001eDG\u000fI\u0001\n[\u0006Dh*^7cKJ,\u0012a\u001b\t\u0003S1L!!\u001c\u0016\u0003\u0007%sG/\u0001\u0006nCbtU/\u001c2fe\u0002\naaY8ti\u001asW#A9\u0011\t%\u0012\b+Z\u0005\u0003g*\u0012\u0011BR;oGRLwN\\\u0019\u0002\u000f\r|7\u000f\u001e$oA\u0005A\u0011N\u001c;feZ\fG.F\u0001x!\tAX0D\u0001z\u0015\tQ80\u0001\u0005ekJ\fG/[8o\u0015\ta(&\u0001\u0006d_:\u001cWO\u001d:f]RL!A`=\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006I\u0011N\u001c;feZ\fG\u000e\t\u000b\u000b\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001cA\u0013\u0006!\")1M\u0004a\u0001K\")\u0011N\u0004a\u0001W\")qN\u0004a\u0001c\")QO\u0004a\u0001o\u0006\u0011\u0011N\\\u000b\u0003\u0003#\u0001B!TA\n!&\u0019\u0011Q\u0003\u000f\u0003\u000b%sG.\u001a;\u0002\u0007%t\u0007%A\u0002pkR,\"!!\b\u0011\t5\u000bybW\u0005\u0004\u0003Ca\"AB(vi2,G/\u0001\u0003pkR\u0004\u0013!E5oSRL\u0017\r\\!uiJL'-\u001e;fgV\u0011\u0011\u0011\u0006\t\u0004\u001b\u0006-\u0012bAA\u00179\tQ\u0011\t\u001e;sS\n,H/Z:\u0002\u000bMD\u0017\r]3\u0016\u00031\u000baa\u001d5ba\u0016\u0004\u0013aC2sK\u0006$X\rT8hS\u000e$B!!\u000f\u0002@A\u0019q)a\u000f\n\u0007\u0005u\u0002JA\bHe\u0006\u0004\bn\u0015;bO\u0016dunZ5d\u0011\u001d\t\tE\u0006a\u0001\u0003S\t1#\u001b8iKJLG/\u001a3BiR\u0014\u0018NY;uKND#!B\u001f")
@InternalApi
public final class GroupedWeightedWithin<T>
extends GraphStage<FlowShape<T, Seq<T>>> {
    private final long maxWeight;
    private final int maxNumber;
    private final Function1<T, Object> costFn;
    private final FiniteDuration interval;
    private final Inlet<T> in;
    private final Outlet<Seq<T>> out;
    private final FlowShape<T, Seq<T>> shape;

    public static String groupedWeightedWithinTimer() {
        return GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer();
    }

    public long maxWeight() {
        return this.maxWeight;
    }

    public int maxNumber() {
        return this.maxNumber;
    }

    public Function1<T, Object> costFn() {
        return this.costFn;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    public Inlet<T> in() {
        return this.in;
    }

    public Outlet<Seq<T>> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        Function1<T, Object> forLambda_lambda = this.costFn();
        Object var1_1 = null;
        return Stages$DefaultAttributes$.MODULE$.groupedWeightedWithin().and(new Attributes.SourceLocation(forLambda_lambda));
    }

    @Override
    public FlowShape<T, Seq<T>> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final VectorBuilder<T> buf;
            private T pending;
            private long pendingWeight;
            private boolean pushEagerly;
            private boolean groupEmitted;
            private boolean finished;
            private long totalWeight;
            private int totalNumber;
            private boolean hasElements;
            private final ContextPropagation contextPropagation;
            private final /* synthetic */ GroupedWeightedWithin $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$(this, cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            private VectorBuilder<T> buf() {
                return this.buf;
            }

            private T pending() {
                return this.pending;
            }

            private void pending_$eq(T x$1) {
                this.pending = x$1;
            }

            private long pendingWeight() {
                return this.pendingWeight;
            }

            private void pendingWeight_$eq(long x$1) {
                this.pendingWeight = x$1;
            }

            private boolean pushEagerly() {
                return this.pushEagerly;
            }

            private void pushEagerly_$eq(boolean x$1) {
                this.pushEagerly = x$1;
            }

            private boolean groupEmitted() {
                return this.groupEmitted;
            }

            private void groupEmitted_$eq(boolean x$1) {
                this.groupEmitted = x$1;
            }

            private boolean finished() {
                return this.finished;
            }

            private void finished_$eq(boolean x$1) {
                this.finished = x$1;
            }

            private long totalWeight() {
                return this.totalWeight;
            }

            private void totalWeight_$eq(long x$1) {
                this.totalWeight = x$1;
            }

            private int totalNumber() {
                return this.totalNumber;
            }

            private void totalNumber_$eq(int x$1) {
                this.totalNumber = x$1;
            }

            private boolean hasElements() {
                return this.hasElements;
            }

            private void hasElements_$eq(boolean x$1) {
                this.hasElements = x$1;
            }

            private ContextPropagation contextPropagation() {
                return this.contextPropagation;
            }

            public void preStart() {
                this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                this.pull(this.$outer.in());
            }

            private void nextElement(T elem) {
                this.groupEmitted_$eq(false);
                long cost = BoxesRunTime.unboxToLong((Object)this.$outer.costFn().apply(elem));
                if (cost < 0L) {
                    this.failStage(new IllegalArgumentException(new StringBuilder(48).append("Negative weight [").append(cost).append("] for element [").append(elem).append("] is not allowed").toString()));
                    return;
                }
                this.hasElements_$eq(true);
                if (this.totalWeight() + cost <= this.$outer.maxWeight() && this.totalNumber() + 1 <= this.$outer.maxNumber()) {
                    this.buf().$plus$eq(elem);
                    this.totalWeight_$eq(this.totalWeight() + cost);
                    this.totalNumber_$eq(this.totalNumber() + 1);
                    if (this.totalWeight() < this.$outer.maxWeight() && this.totalNumber() < this.$outer.maxNumber()) {
                        this.pull(this.$outer.in());
                        return;
                    }
                    if (!this.isAvailable(this.$outer.out())) {
                        this.pushEagerly_$eq(true);
                        this.pull(this.$outer.in());
                        return;
                    }
                    this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                    this.emitGroup();
                    return;
                }
                if (this.totalWeight() == 0L && this.totalNumber() == 0) {
                    this.buf().$plus$eq(elem);
                    this.totalWeight_$eq(this.totalWeight() + cost);
                    this.totalNumber_$eq(this.totalNumber() + 1);
                    this.pushEagerly_$eq(true);
                } else {
                    this.pending_$eq(elem);
                    this.pendingWeight_$eq(cost);
                }
                this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                this.tryCloseGroup();
            }

            private void tryCloseGroup() {
                if (this.isAvailable(this.$outer.out())) {
                    this.emitGroup();
                    return;
                }
                if (this.pending() != null || this.finished()) {
                    this.pushEagerly_$eq(true);
                    return;
                }
            }

            private void emitGroup() {
                this.groupEmitted_$eq(true);
                this.contextPropagation().resumeContext();
                this.push(this.$outer.out(), this.buf().result());
                this.buf().clear();
                if (!this.finished()) {
                    this.startNewGroup();
                    return;
                }
                if (this.pending() != null) {
                    this.emit(this.$outer.out(), package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.pending()})), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.completeStage());
                    return;
                }
                this.completeStage();
            }

            private void startNewGroup() {
                if (this.pending() != null) {
                    this.totalWeight_$eq(this.pendingWeight());
                    this.totalNumber_$eq(1);
                    this.pendingWeight_$eq(0L);
                    this.buf().$plus$eq(this.pending());
                    this.pending_$eq(null);
                    this.groupEmitted_$eq(false);
                } else {
                    this.totalWeight_$eq(0L);
                    this.totalNumber_$eq(0);
                    this.hasElements_$eq(false);
                }
                this.pushEagerly_$eq(false);
                if (this.isAvailable(this.$outer.in())) {
                    this.nextElement(this.grab(this.$outer.in()));
                    return;
                }
                if (!this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onPush() {
                this.contextPropagation().suspendContext();
                if (this.pending() == null) {
                    this.nextElement(this.grab(this.$outer.in()));
                    return;
                }
            }

            public void onPull() {
                if (this.pushEagerly()) {
                    this.emitGroup();
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.finished_$eq(true);
                if (this.groupEmitted()) {
                    this.completeStage();
                    return;
                }
                this.tryCloseGroup();
            }

            public void onTimer(Object timerKey) {
                if (this.hasElements()) {
                    if (this.isAvailable(this.$outer.out())) {
                        this.emitGroup();
                        return;
                    }
                    this.pushEagerly_$eq(true);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                this.buf = new VectorBuilder();
                this.pending = null;
                this.pendingWeight = 0L;
                this.pushEagerly = false;
                this.groupEmitted = true;
                this.finished = false;
                this.totalWeight = 0L;
                this.totalNumber = 0;
                this.hasElements = false;
                this.contextPropagation = new ContextPropagationImpl();
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$emitGroup$1(org.apache.pekko.stream.impl.fusing.GroupedWeightedWithin$$anon$35 )}, serializedLambda);
            }
        };
    }

    public GroupedWeightedWithin(long maxWeight, int maxNumber, Function1<T, Object> costFn, FiniteDuration interval) {
        this.maxWeight = maxWeight;
        this.maxNumber = maxNumber;
        this.costFn = costFn;
        this.interval = interval;
        Predef$.MODULE$.require(maxWeight > 0L, (Function0 & Serializable)() -> "maxWeight must be greater than 0");
        Predef$.MODULE$.require(maxNumber > 0, (Function0 & Serializable)() -> "maxNumber must be greater than 0");
        Predef$.MODULE$.require(interval.$greater((Object)Duration$.MODULE$.Zero()));
        String apply_name = "in";
        Object var6_5 = null;
        this.in = new Inlet(apply_name);
        String apply_name2 = "out";
        Object var7_6 = null;
        this.out = new Outlet(apply_name2);
        this.shape = new FlowShape<T, Seq<T>>(this.in(), this.out());
    }
}

