/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.util.AttributeKey;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.time.Clock;
import java.time.Instant;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.ProxyInformation;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.api.handler.DisconnectHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.protocols.netty.LineHandlerAware;
import org.apache.james.protocols.netty.NettyProtocolTransport;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicChannelInboundHandler
extends ChannelInboundHandlerAdapter
implements LineHandlerAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicChannelInboundHandler.class);
    public static final AttributeKey<Instant> CONNECTION_DATE = AttributeKey.newInstance((String)"smtpConnectionDate");
    public static final ProtocolSession.AttachmentKey<MDCBuilder> MDC_ATTRIBUTE_KEY = ProtocolSession.AttachmentKey.of((String)"bound_MDC", MDCBuilder.class);
    public static final AttributeKey<CommandDetectionSession> SESSION_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"session");
    protected final Protocol protocol;
    protected final ProtocolHandlerChain chain;
    protected final Encryption secure;
    protected final boolean proxyRequired;
    private final ProtocolMDCContextFactory mdcContextFactory;
    private final Deque<ChannelInboundHandlerAdapter> behaviourOverrides = new ConcurrentLinkedDeque<ChannelInboundHandlerAdapter>();
    private final Optional<LineHandler> lineHandler;
    protected final LinkedList<ProtocolHandlerResultHandler> resultHandlers;

    public BasicChannelInboundHandler(ProtocolMDCContextFactory mdcContextFactory, Protocol protocol) {
        this(mdcContextFactory, protocol, null, false);
    }

    public BasicChannelInboundHandler(ProtocolMDCContextFactory mdcContextFactory, Protocol protocol, Encryption secure, boolean proxyRequired) {
        this.mdcContextFactory = mdcContextFactory;
        this.protocol = protocol;
        this.chain = protocol.getProtocolChain();
        this.secure = secure;
        this.proxyRequired = proxyRequired;
        this.lineHandler = this.chain.getFirstHandler(LineHandler.class);
        this.resultHandlers = this.chain.getHandlers(ProtocolHandlerResultHandler.class);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        MDCBuilder boundMDC = this.mdcContextFactory.onBound(this.protocol, ctx);
        ctx.channel().attr(CONNECTION_DATE).set((Object)Clock.systemUTC().instant());
        try (Closeable closeable = boundMDC.build();){
            ProtocolSession session = this.createSession(ctx);
            session.setAttachment(MDC_ATTRIBUTE_KEY, (Object)boundMDC, ProtocolSession.State.Connection);
            ctx.channel().attr(SESSION_ATTRIBUTE_KEY).set((Object)session);
            LinkedList connectHandlers = this.chain.getHandlers(ConnectHandler.class);
            LinkedList resultHandlers = this.chain.getHandlers(ProtocolHandlerResultHandler.class);
            LOGGER.info("Connection established from {}", (Object)session.getRemoteAddress().getAddress().getHostAddress());
            for (ConnectHandler cHandler : connectHandlers) {
                long start = System.currentTimeMillis();
                Response response = cHandler.onConnect(session);
                long executionTime = System.currentTimeMillis() - start;
                for (ProtocolHandlerResultHandler resultHandler : resultHandlers) {
                    resultHandler.onResponse(session, response, executionTime, (ProtocolHandler)cHandler);
                }
                if (response == null) continue;
                ((ProtocolSessionImpl)session).getProtocolTransport().writeResponse(response, session);
            }
            super.channelActive(ctx);
        }
    }

    private MDCBuilder mdc(ChannelHandlerContext ctx) {
        ProtocolSession session = (ProtocolSession)ctx.channel().attr(SESSION_ATTRIBUTE_KEY).get();
        return Optional.ofNullable(session).flatMap(s -> s.getAttachment(MDC_ATTRIBUTE_KEY, ProtocolSession.State.Connection)).map(mdc -> this.mdcContextFactory.withContext(session).addToContext(mdc)).orElseGet(MDCBuilder::create);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            LinkedList connectHandlers = this.chain.getHandlers(DisconnectHandler.class);
            ProtocolSession session = (ProtocolSession)ctx.channel().attr(SESSION_ATTRIBUTE_KEY).get();
            if (connectHandlers != null) {
                for (DisconnectHandler connectHandler : connectHandlers) {
                    connectHandler.onDisconnect(session);
                }
            }
            LOGGER.info("Connection closed for {}", (Object)ctx.channel().remoteAddress());
            this.cleanup(ctx);
            super.channelInactive(ctx);
        }
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            this.handleHAProxyMessage(ctx, (HAProxyMessage)msg);
            return;
        }
        ChannelInboundHandlerAdapter override = this.behaviourOverrides.peekFirst();
        if (override != null) {
            try (Closeable closeable = this.mdc(ctx).build();){
                override.channelRead(ctx, msg);
            }
            return;
        }
        try (Closeable closeable = this.mdc(ctx).build();){
            ProtocolSession pSession = (ProtocolSession)ctx.channel().attr(SESSION_ATTRIBUTE_KEY).get();
            if (this.lineHandler.isPresent()) {
                ByteBuf buf = (ByteBuf)msg;
                byte[] bytes = new byte[buf.readableBytes()];
                buf.getBytes(0, bytes);
                LineHandler lHandler = this.lineHandler.get();
                long start = System.currentTimeMillis();
                Response response = lHandler.onLine(pSession, bytes);
                long executionTime = System.currentTimeMillis() - start;
                for (ProtocolHandlerResultHandler resultHandler : this.resultHandlers) {
                    response = resultHandler.onResponse(pSession, response, executionTime, (ProtocolHandler)lHandler);
                }
                if (response != null) {
                    ((ProtocolSessionImpl)pSession).getProtocolTransport().writeResponse(response, pSession);
                }
            }
            super.channelReadComplete(ctx);
        }
        finally {
            ((ByteBuf)msg).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHAProxyMessage(ChannelHandlerContext ctx, HAProxyMessage haproxyMsg) throws Exception {
        try {
            ProtocolSession pSession = (ProtocolSession)ctx.channel().attr(SESSION_ATTRIBUTE_KEY).get();
            if (haproxyMsg.proxiedProtocol().equals((Object)HAProxyProxiedProtocol.TCP4) || haproxyMsg.proxiedProtocol().equals((Object)HAProxyProxiedProtocol.TCP6)) {
                ProxyInformation proxyInformation = new ProxyInformation(new InetSocketAddress(haproxyMsg.sourceAddress(), haproxyMsg.sourcePort()), new InetSocketAddress(haproxyMsg.destinationAddress(), haproxyMsg.destinationPort()));
                LOGGER.info("Connection from {} runs through {} proxy", (Object)haproxyMsg.sourceAddress(), (Object)haproxyMsg.destinationAddress());
                if (pSession != null) {
                    pSession.setProxyInformation(proxyInformation);
                    MDCBuilder boundMDC = this.mdcContextFactory.onBound(this.protocol, ctx);
                    boundMDC.addToContext("proxy.source", proxyInformation.getSource().toString());
                    boundMDC.addToContext("proxy.destination", proxyInformation.getDestination().toString());
                    boundMDC.addToContext("proxy.ip", BasicChannelInboundHandler.retrieveIp(ctx));
                    pSession.setAttachment(MDC_ATTRIBUTE_KEY, (Object)boundMDC, ProtocolSession.State.Connection);
                }
            } else {
                throw new IllegalArgumentException("Only TCP4/TCP6 are supported when using PROXY protocol.");
            }
            super.channelReadComplete(ctx);
        }
        finally {
            haproxyMsg.release();
        }
    }

    protected void cleanup(ChannelHandlerContext ctx) {
        ProtocolSession session = (ProtocolSession)ctx.channel().attr(SESSION_ATTRIBUTE_KEY).getAndSet(null);
        if (session != null) {
            session.resetState();
        }
        ctx.close();
    }

    protected ProtocolSession createSession(ChannelHandlerContext ctx) {
        return this.protocol.newSession((ProtocolTransport)new NettyProtocolTransport(ctx.channel(), this.secure, this.proxyRequired));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try (Closeable closeable = this.mdc(ctx).build();){
            Channel channel = ctx.channel();
            ProtocolSession session = (ProtocolSession)ctx.channel().attr(SESSION_ATTRIBUTE_KEY).get();
            if (cause instanceof TooLongFrameException && session != null) {
                Response r = session.newLineTooLongResponse();
                ProtocolTransport transport = ((ProtocolSessionImpl)session).getProtocolTransport();
                if (r != null) {
                    transport.writeResponse(r, session);
                }
            } else {
                if (channel.isActive() && session != null) {
                    ProtocolTransport transport = ((ProtocolSessionImpl)session).getProtocolTransport();
                    Response r = session.newFatalErrorResponse();
                    if (r != null) {
                        transport.writeResponse(r, session);
                    }
                    transport.writeResponse(Response.DISCONNECT, session);
                }
                if (cause instanceof SocketException) {
                    LOGGER.info("Socket exception encountered: {}", (Object)cause.getMessage());
                } else if (this.isSslHandshkeException(cause)) {
                    LOGGER.info("SSH handshake rejected {}", (Object)cause.getMessage());
                } else if (this.isNotSslRecordException(cause)) {
                    LOGGER.info("Not an SSL record {}", (Object)cause.getMessage());
                } else if (this.isSslException(cause)) {
                    LOGGER.info("Encountered SSL exception: {}", (Object)cause.getMessage());
                } else if (!(cause instanceof ClosedChannelException)) {
                    LOGGER.error("Unable to process request", cause);
                }
                ctx.close();
            }
        }
    }

    private boolean isSslHandshkeException(Throwable cause) {
        return cause instanceof DecoderException && cause.getCause() instanceof SSLHandshakeException;
    }

    private boolean isNotSslRecordException(Throwable cause) {
        return cause instanceof DecoderException && cause.getCause() instanceof NotSslRecordException;
    }

    private boolean isSslException(Throwable cause) {
        return cause instanceof DecoderException && cause.getCause() instanceof SSLException;
    }

    @Override
    public void pushLineHandler(ChannelInboundHandlerAdapter lineHandlerUpstreamHandler) {
        this.behaviourOverrides.addFirst(lineHandlerUpstreamHandler);
    }

    @Override
    public void popLineHandler() {
        if (!this.behaviourOverrides.isEmpty()) {
            this.behaviourOverrides.removeFirst();
        }
    }
}

