/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoV2;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Iterators;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraMailRepository
implements MailRepository {
    private final MailRepositoryUrl url;
    private final CassandraMailRepositoryKeysDAO keysDAO;
    private final CassandraMailRepositoryMailDaoV2 mailDAO;
    private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;

    @Inject
    CassandraMailRepository(MailRepositoryUrl url, CassandraMailRepositoryKeysDAO keysDAO, CassandraMailRepositoryMailDaoV2 mailDAO, MimeMessageStore.Factory mimeMessageStoreFactory) {
        this.url = url;
        this.keysDAO = keysDAO;
        this.mailDAO = mailDAO;
        this.mimeMessageStore = mimeMessageStoreFactory.mimeMessageStore();
    }

    public MailKey store(Mail mail) throws MessagingException {
        MailKey mailKey = MailKey.forMail((Mail)mail);
        return (MailKey)this.mimeMessageStore.save((Object)mail.getMessage()).flatMap(parts -> this.mailDAO.store(this.url, mail, parts.getHeaderBlobId(), parts.getBodyBlobId())).then(this.keysDAO.store(this.url, mailKey)).doOnSuccess((Consumer)Throwing.consumer(any -> AuditTrail.entry().protocol("mailrepository").action("store").parameters((Supplier)Throwing.supplier(() -> ImmutableMap.of((Object)"mailId", (Object)mail.getName(), (Object)"mimeMessageId", (Object)Optional.ofNullable(mail.getMessage()).map(Throwing.function(MimeMessage::getMessageID)).orElse(""), (Object)"url", (Object)this.url.asString(), (Object)"error", (Object)Optional.ofNullable(mail.getErrorMessage()).orElse(""), (Object)"sender", (Object)mail.getMaybeSender().asString(), (Object)"recipients", (Object)StringUtils.join((Object[])new Collection[]{mail.getRecipients()})))).log("CassandraMailRepository stored mail."))).thenReturn((Object)mailKey).block();
    }

    public Iterator<MailKey> list() {
        return this.keysDAO.list(this.url).toIterable().iterator();
    }

    public Iterator<MailKey> list(MailRepository.Condition condition) {
        return Iterators.toStream(this.list()).filter(key -> {
            Mail mail = this.retrieveMetadata((MailKey)key);
            return condition.test((Object)mail);
        }).iterator();
    }

    private Mail retrieveMetadata(MailKey key) {
        return (Mail)this.mailDAO.read(this.url, key).handle(ReactorUtils.publishIfPresent()).map(mailDTO -> mailDTO.getMailBuilder().build()).block();
    }

    public Mail retrieve(MailKey key) {
        return this.mailDAO.read(this.url, key).handle(ReactorUtils.publishIfPresent()).flatMap(this::toMail).blockOptional().orElse(null);
    }

    private Mono<Mail> toMail(CassandraMailRepositoryMailDaoV2.MailDTO mailDTO) {
        MimeMessagePartsId parts = this.blobIds(mailDTO);
        return this.mimeMessageStore.read((Object)parts).map((Function)Throwing.function(mimeMessage -> {
            MailImpl mail = mailDTO.getMailBuilder().build();
            if (mimeMessage instanceof MimeMessageWrapper) {
                mail.setMessageNoCopy((MimeMessageWrapper)mimeMessage);
            } else {
                mail.setMessage(mimeMessage);
            }
            return mail;
        }));
    }

    private MimeMessagePartsId blobIds(CassandraMailRepositoryMailDaoV2.MailDTO mailDTO) {
        return MimeMessagePartsId.builder().headerBlobId(mailDTO.getHeaderBlobId()).bodyBlobId(mailDTO.getBodyBlobId()).build();
    }

    public void remove(MailKey key) {
        this.removeAsync(key).block();
    }

    private Mono<Void> removeAsync(MailKey key) {
        return this.mailDAO.read(this.url, key).flatMap(maybeMailDTO -> this.keysDAO.remove(this.url, key).then(this.mailDAO.remove(this.url, key)).then(this.deleteBlobs((Optional<CassandraMailRepositoryMailDaoV2.MailDTO>)maybeMailDTO)));
    }

    private Mono<Void> deleteBlobs(Optional<CassandraMailRepositoryMailDaoV2.MailDTO> maybeMailDTO) {
        return Mono.justOrEmpty(maybeMailDTO).flatMap(mailDTO -> Mono.from((Publisher)this.mimeMessageStore.delete((Object)this.blobIds((CassandraMailRepositoryMailDaoV2.MailDTO)mailDTO))));
    }

    public long size() {
        return (Long)this.keysDAO.getCount(this.url).block();
    }

    public Publisher<Long> sizeReactive() {
        return this.keysDAO.getCount(this.url);
    }

    public void removeAll() {
        this.keysDAO.list(this.url).flatMap(this::removeAsync, 16).then().block();
    }
}

