/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ArrayPercentilesItem
implements PlainJsonSerializable {
    private final String key;
    private final double value;
    @Nullable
    private final String valueAsString;
    public static final JsonpDeserializer<ArrayPercentilesItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayPercentilesItem::setupArrayPercentilesItemDeserializer);

    private ArrayPercentilesItem(Builder builder) {
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.valueAsString = builder.valueAsString;
    }

    public static ArrayPercentilesItem of(Function<Builder, ObjectBuilder<ArrayPercentilesItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String key() {
        return this.key;
    }

    public final double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("key");
        generator.write(this.key);
        generator.writeKey("value");
        JsonpUtils.serializeDoubleOrNull(generator, this.value, 0.0);
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    protected static void setupArrayPercentilesItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
        op.add(Builder::value, JsonpDeserializer.doubleOrNullDeserializer(0.0), "value");
        op.add(Builder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ArrayPercentilesItem> {
        private String key;
        private Double value;
        @Nullable
        private String valueAsString;

        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        public final Builder value(double value) {
            this.value = value;
            return this;
        }

        public final Builder valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return this;
        }

        @Override
        public ArrayPercentilesItem build() {
            this._checkSingleUse();
            return new ArrayPercentilesItem(this);
        }
    }
}

