/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LogoutRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class LogoutProcessor
extends AbstractMailboxProcessor<LogoutRequest> {
    @Inject
    public LogoutProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(LogoutRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(LogoutRequest request, ImapSession session, ImapProcessor.Responder responder) {
        return session.logout().then(Mono.fromRunnable(() -> {
            this.bye(responder);
            this.okComplete(request, responder);
            responder.flush();
        }));
    }

    @Override
    protected MDCBuilder mdc(LogoutRequest request) {
        return MDCBuilder.create().addToContext("action", "LOGOUT");
    }
}

