/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.oss.driver.api.core.CqlSession;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.backends.cassandra.components.CassandraTable;
import org.apache.james.backends.cassandra.components.CassandraType;
import org.apache.james.backends.cassandra.init.CassandraTableManager;
import org.apache.james.backends.cassandra.init.CassandraTypesCreator;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;

@Singleton
public class SessionWithInitializedTablesFactory
implements Provider<CqlSession> {
    private final CassandraDataDefinition module;
    private final CqlSession session;

    @Inject
    public SessionWithInitializedTablesFactory(CqlSession cluster, CassandraDataDefinition module) {
        this.module = module;
        this.session = this.createSession(cluster);
    }

    private CqlSession createSession(CqlSession cluster) {
        try {
            if (this.allOperationsAreFullyPerformed(cluster, this.module)) {
                new CassandraSchemaVersionDAO(cluster).updateVersion(CassandraSchemaVersionManager.MAX_VERSION).block();
            }
            return cluster;
        }
        catch (Exception e) {
            cluster.close();
            throw e;
        }
    }

    private boolean allOperationsAreFullyPerformed(CqlSession session, CassandraDataDefinition module) {
        boolean types = this.createTypes(session, module);
        boolean tables = this.createTables(session, module);
        return types && tables;
    }

    private boolean createTypes(CqlSession session, CassandraDataDefinition module) {
        return new CassandraTypesCreator(module, session).initializeTypes() == CassandraType.InitializationStatus.FULL;
    }

    private boolean createTables(CqlSession session, CassandraDataDefinition module) {
        CassandraTypesProvider cassandraTypesProvider = new CassandraTypesProvider(session);
        return new CassandraTableManager(module, session).initializeTables(cassandraTypesProvider) == CassandraTable.InitializationStatus.FULL;
    }

    public CqlSession get() {
        return this.session;
    }

    @PreDestroy
    public synchronized void destroy() {
        this.session.close();
    }
}

