/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveBooleanCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class BooleanCodec
implements PrimitiveBooleanCodec {
    private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
    private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});

    @Override
    @NonNull
    public GenericType<Boolean> getJavaType() {
        return GenericType.BOOLEAN;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Boolean;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Boolean.class || javaClass == Boolean.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(boolean value, @NonNull ProtocolVersion protocolVersion) {
        return value ? TRUE.duplicate() : FALSE.duplicate();
    }

    @Override
    public boolean decodePrimitive(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return false;
        }
        if (bytes.remaining() != 1) {
            throw new IllegalArgumentException("Invalid boolean value, expecting 1 byte but got " + bytes.remaining());
        }
        return bytes.get(bytes.position()) != 0;
    }

    @Override
    @NonNull
    public String format(@Nullable Boolean value) {
        if (value == null) {
            return "NULL";
        }
        return value != false ? "true" : "false";
    }

    @Override
    @Nullable
    public Boolean parse(@Nullable String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (value.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        throw new IllegalArgumentException(String.format("Cannot parse boolean value from \"%s\"", value));
    }

    @Override
    @NonNull
    public Optional<Integer> serializedSize() {
        return Optional.of(1);
    }
}

