/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;

public class ModFormat
extends ModBase {
    protected final ArgDecl resultsFmtDecl = new ArgDecl(true, "fmt", "format");
    private String format = "N-TRIPLES";
    static final List<String> formats = Arrays.asList("RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N3", "N3-PP", "N3-PLAIN", "N3-TRIPLES", "N3-TRIPLE", "TURTLE", "TTL");

    @Override
    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.resultsFmtDecl)) {
            String rFmt = cmdline.getValue(this.resultsFmtDecl);
            this.format = this.lookup(rFmt);
            if (this.format == null) {
                cmdline.cmdError("Unrecognized format: " + rFmt);
            }
        }
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output format");
        cmdLine.add(this.resultsFmtDecl, "--format", "Format (Result sets: text, XML, JSON; Graph: RDF serialization)");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public String getFormat() {
        return this.format;
    }

    public String getFormat(String defaultFormat) {
        if (this.format == null) {
            return defaultFormat;
        }
        return this.format;
    }

    private String lookup(String fmt) {
        return formats.stream().filter(fmt::equalsIgnoreCase).findFirst().orElse("TURTLE");
    }
}

