/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import arq.cmdline.CmdARQ;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.cmd.ModVersion;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.base.file.FileFactory;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.base.objectfile.StringFile;
import org.apache.jena.tdb1.setup.Build;
import org.apache.jena.tdb1.solver.stats.Stats;
import org.apache.jena.tdb1.solver.stats.StatsResults;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.DatasetPrefixesTDB;
import org.apache.jena.tdb1.sys.DatasetControl;
import org.apache.jena.tdb1.sys.DatasetControlNone;
import tdb.cmdline.CmdSub;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;
import tdb.tdbstats;

public class tdbconfig
extends CmdSub {
    static final String CMD_CLEAN = "clean";
    static final String CMD_HELP = "help";
    static final String CMD_STATS = "stats";
    static final String CMD_NODES = "nodes";
    static final String CMD_INFO = "info";
    static final String CMD_PREFIXES = "prefixes";

    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbconfig(argv).exec();
    }

    protected tdbconfig(String[] argv) {
        super(argv);
        super.addSubCommand(CMD_HELP, new CmdSub.Exec(){

            @Override
            public void exec(String[] argv) {
                new SubHelp(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_STATS, new CmdSub.Exec(this){

            @Override
            public void exec(String[] argv) {
                new SubStats(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_NODES, new CmdSub.Exec(this){

            @Override
            public void exec(String[] argv) {
                new SubNodes(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_INFO, new CmdSub.Exec(this){

            @Override
            public void exec(String[] argv) {
                new SubInfo(argv).mainRun();
            }
        });
        super.addSubCommand(CMD_PREFIXES, new CmdSub.Exec(this){

            @Override
            public void exec(String[] argv) {
                new SubPrefixes(argv).mainRun();
            }
        });
    }

    static class SubInfo
    extends CmdTDB {
        public SubInfo(String ... argv) {
            super(argv);
        }

        @Override
        protected String getSummary() {
            return "tdbconfig info";
        }

        @Override
        protected void exec() {
            System.out.println("-- " + DateTimeUtils.nowAsString() + " --");
            ModVersion v = new ModVersion(true);
            v.addClass("TDB1", TDB1.class);
            v.printVersionAndExit();
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig info";
        }
    }

    static class SubNodes
    extends CmdTDB {
        public SubNodes(String ... argv) {
            super(argv);
        }

        @Override
        protected String getSummary() {
            return "tdbconfig nodes";
        }

        @Override
        protected void exec() {
            List args = this.positionals;
            for (String x : args) {
                System.out.println("**** Object File: " + x);
                StringFile objs = FileFactory.createStringFileDisk((String)x);
                objs.dump();
            }
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig nodes";
        }
    }

    static class SubStats
    extends CmdTDBGraph {
        public SubStats(String ... argv) {
            super(argv);
        }

        @Override
        protected String getSummary() {
            return "tdbconfig stats";
        }

        @Override
        protected void exec() {
            DatasetGraphTDB dsg = this.getDatasetGraphTDB();
            Node gn = this.getGraphName();
            StatsResults results = tdbstats.stats(dsg, gn);
            Stats.write((OutputStream)System.out, (StatsResults)results);
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig stats";
        }
    }

    class SubHelp
    extends CmdARQ {
        public SubHelp(String ... argv) {
            super(argv);
        }

        @Override
        protected String getSummary() {
            return null;
        }

        @Override
        protected void exec() {
            IndentedWriter out = IndentedWriter.stdout;
            out.println("Sub-commands:");
            out.incIndent();
            for (String name : tdbconfig.this.subCommandNames()) {
                out.println(name);
            }
            out.decIndent();
            out.flush();
        }

        @Override
        protected String getCommandName() {
            return "tdbconfig help";
        }
    }

    static class SubPrefixes
    extends CmdTDB {
        public SubPrefixes(String ... argv) {
            super(argv);
        }

        @Override
        protected String getSummary() {
            return "tdbconfig prefixes";
        }

        @Override
        protected void exec() {
            Location location = this.getLocation();
            DatasetPrefixesTDB prefixes = Build.makePrefixes((Location)location, (DatasetControl)new DatasetControlNone());
            for (String gn : prefixes.graphNames()) {
                System.out.println("Graph: " + gn);
                PrefixMap pmap = prefixes.getPrefixMap(gn);
                Map x = pmap.getMapping();
                for (String k : x.keySet()) {
                    System.out.printf("  %-10s %s\n", k + ":", x.get(k));
                }
            }
        }
    }
}

