/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.tdb2.store.value;

import org.apache.jena.atlas.lib.BitsLong;

public class IntegerNode {
    // 56 bits of value, including sign bit.
    public static final int  LEN   = 56;
    public static final int  LBITS = Long.SIZE;
    public static final long MAX   = (1L << (LEN - 1)) - 1;
    public static final long MIN   = -(1L << (LEN - 1));

    public static long pack(long v) {
        if ( v >= MIN && v <= MAX ) {
            v = BitsLong.clear(v, LEN, LBITS);
            return v;
        } else
            return -1;
    }

    public static long unpack(long v) {
        long val = BitsLong.clear(v, LEN, LBITS);
        // Sign extends to 64 bits.
        if ( BitsLong.isSet(val, LEN - 1) )
            val = BitsLong.set(v, LEN, LBITS);
        return val;
    }

    // Same - renamed.

    public static long pack56(long v) {
        if ( v >= MIN && v <= MAX ) {
            v = BitsLong.clear(v, LEN, LBITS);
            return v;
        } else
            return -1;
    }

    public static long unpack56(long v) {
        long val = BitsLong.clear(v, LEN, LBITS);
        // Sign extends to 64 bits.
        if ( BitsLong.isSet(val, LEN - 1) )
            val = BitsLong.set(v, LEN, LBITS);
        return val;
    }

}
