/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Locale;

public class JMeterFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String[] exts;
    private final boolean allowDirs;

    public JMeterFileFilter(String[] extensions) {
        this(extensions, true);
    }

    public JMeterFileFilter(String[] extensions, boolean allow) {
        this.exts = extensions;
        this.allowDirs = allow;
    }

    @Override
    public boolean accept(File f) {
        return this.allowDirs && f.isDirectory() || this.accept(f.getName().toLowerCase(Locale.ROOT));
    }

    public boolean accept(String filename) {
        return Arrays.stream(this.exts).anyMatch(filename::endsWith);
    }

    @Override
    public String getDescription() {
        return "JMeter " + Arrays.asList(this.exts).toString();
    }
}

