/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Function.class})
public class RegexFunction
extends AbstractFunction {
    private static final Logger log = LoggerFactory.getLogger(RegexFunction.class);
    public static final String ALL = "ALL";
    public static final String RAND = "RAND";
    public static final String KEY = "__regexFunction";
    private Object[] values;
    private static final List<String> desc = new ArrayList<String>();
    private static final Pattern FIRST_ELEMENT_PATTERN = Pattern.compile("^\\$\\d+\\$");
    private static final String TEMPLATE_PATTERN = "\\$(\\d+)\\$";
    private final org.apache.oro.text.regex.Pattern templatePattern = JMeterUtils.getPatternCache().getPattern("\\$(\\d+)\\$", 32768);
    private static final Pattern templatePatternJava = Pattern.compile("\\$(\\d+)\\$");
    private static final int MIN_PARAMETER_COUNT = 2;
    private static final int MAX_PARAMETER_COUNT = 7;
    private static final boolean USE_JAVA_REGEX;

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String dv;
        String valueIndex = "";
        String defaultValue = "";
        String between = "";
        String name = "";
        String inputVariable = "";
        Object[] tmplt = this.generateTemplate(((CompoundVariable)this.values[1]).execute());
        if (this.values.length > 2) {
            valueIndex = ((CompoundVariable)this.values[2]).execute();
        }
        if (valueIndex.isEmpty()) {
            valueIndex = "1";
        }
        if (this.values.length > 3) {
            between = ((CompoundVariable)this.values[3]).execute();
        }
        if (this.values.length > 4 && !(dv = ((CompoundVariable)this.values[4]).execute()).isEmpty()) {
            defaultValue = dv;
        }
        if (this.values.length > 5) {
            name = ((CompoundVariable)this.values[5]).execute();
        }
        if (this.values.length > 6) {
            inputVariable = ((CompoundVariable)this.values[6]).execute();
        }
        if ((vars = this.getVariables()) == null) {
            return defaultValue;
        }
        if (!name.isEmpty()) {
            vars.put(name, defaultValue);
        }
        String textToMatch = null;
        if (!inputVariable.isEmpty()) {
            textToMatch = vars.get(inputVariable);
        } else if (previousResult != null) {
            textToMatch = previousResult.getResponseDataAsString();
        }
        if (textToMatch == null || textToMatch.isEmpty()) {
            return defaultValue;
        }
        if (USE_JAVA_REGEX) {
            return this.getResultWithJavaRegex(valueIndex, defaultValue, between, name, tmplt, vars, textToMatch);
        }
        return this.getResultWithOroRegex(valueIndex, defaultValue, between, name, tmplt, vars, textToMatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResultWithJavaRegex(String valueIndex, String defaultValue, String between, String name, Object[] tmplt, JMeterVariables vars, String textToMatch) throws InvalidVariableException {
        ArrayList<java.util.regex.MatchResult> collectAllMatches = new ArrayList<java.util.regex.MatchResult>();
        try {
            Pattern searchPattern = this.generateJavaPattern();
            Matcher matcher = searchPattern.matcher(textToMatch);
            while (matcher.find()) {
                java.util.regex.MatchResult match = matcher.toMatchResult();
                collectAllMatches.add(match);
            }
        }
        finally {
            if (!name.isEmpty()) {
                vars.put(name + "_matchNr", Integer.toString(collectAllMatches.size()));
            }
        }
        if (collectAllMatches.isEmpty()) {
            return defaultValue;
        }
        if (valueIndex.equals(ALL)) {
            StringBuilder value = new StringBuilder();
            Iterator it = collectAllMatches.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    value.append(between);
                } else {
                    first = false;
                }
                value.append(RegexFunction.generateResult((java.util.regex.MatchResult)it.next(), name, tmplt, vars));
            }
            return value.toString();
        }
        if (valueIndex.equals(RAND)) {
            java.util.regex.MatchResult result = (java.util.regex.MatchResult)collectAllMatches.get(ThreadLocalRandom.current().nextInt(collectAllMatches.size()));
            return RegexFunction.generateResult(result, name, tmplt, vars);
        }
        try {
            int index = Integer.parseInt(valueIndex) - 1;
            if (index >= collectAllMatches.size()) {
                return defaultValue;
            }
            java.util.regex.MatchResult result = (java.util.regex.MatchResult)collectAllMatches.get(index);
            return RegexFunction.generateResult(result, name, tmplt, vars);
        }
        catch (NumberFormatException e) {
            float ratio = Float.parseFloat(valueIndex);
            java.util.regex.MatchResult result = (java.util.regex.MatchResult)collectAllMatches.get((int)((double)((float)collectAllMatches.size() * ratio) + 0.5) - 1);
            return RegexFunction.generateResult(result, name, tmplt, vars);
        }
    }

    private Pattern generateJavaPattern() throws InvalidVariableException {
        try {
            return JMeterUtils.compilePattern((String)((CompoundVariable)this.values[0]).execute());
        }
        catch (PatternSyntaxException e) {
            log.error("Malformed regex pattern:{}", this.values[0], (Object)e);
            throw new InvalidVariableException("Malformed regex pattern:" + this.values[0], (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResultWithOroRegex(String valueIndex, String defaultValue, String between, String name, Object[] tmplt, JMeterVariables vars, String textToMatch) throws InvalidVariableException {
        ArrayList<MatchResult> collectAllMatches = new ArrayList<MatchResult>();
        try {
            org.apache.oro.text.regex.Pattern searchPattern = this.generateOroPattern();
            Perl5Matcher matcher = JMeterUtils.getMatcher();
            PatternMatcherInput input = new PatternMatcherInput(textToMatch);
            while (matcher.contains(input, searchPattern)) {
                MatchResult match = matcher.getMatch();
                if (match == null) continue;
                collectAllMatches.add(match);
            }
        }
        finally {
            if (!name.isEmpty()) {
                vars.put(name + "_matchNr", Integer.toString(collectAllMatches.size()));
            }
        }
        if (collectAllMatches.isEmpty()) {
            return defaultValue;
        }
        if (valueIndex.equals(ALL)) {
            StringBuilder value = new StringBuilder();
            Iterator it = collectAllMatches.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    value.append(between);
                } else {
                    first = false;
                }
                value.append(RegexFunction.generateResult((MatchResult)it.next(), name, tmplt, vars));
            }
            return value.toString();
        }
        if (valueIndex.equals(RAND)) {
            MatchResult result = (MatchResult)collectAllMatches.get(ThreadLocalRandom.current().nextInt(collectAllMatches.size()));
            return RegexFunction.generateResult(result, name, tmplt, vars);
        }
        try {
            int index = Integer.parseInt(valueIndex) - 1;
            if (index >= collectAllMatches.size()) {
                return defaultValue;
            }
            MatchResult result = (MatchResult)collectAllMatches.get(index);
            return RegexFunction.generateResult(result, name, tmplt, vars);
        }
        catch (NumberFormatException e) {
            float ratio = Float.parseFloat(valueIndex);
            MatchResult result = (MatchResult)collectAllMatches.get((int)((double)((float)collectAllMatches.size() * ratio) + 0.5) - 1);
            return RegexFunction.generateResult(result, name, tmplt, vars);
        }
    }

    private org.apache.oro.text.regex.Pattern generateOroPattern() throws InvalidVariableException {
        try {
            return JMeterUtils.getPatternCache().getPattern(((CompoundVariable)this.values[0]).execute(), 32768);
        }
        catch (MalformedCachePatternException e) {
            log.error("Malformed cache pattern:{}", this.values[0], (Object)e);
            throw new InvalidVariableException("Malformed cache pattern:" + this.values[0], (Throwable)e);
        }
    }

    private static void saveGroups(java.util.regex.MatchResult result, String namep, JMeterVariables vars) {
        for (int x = 0; x <= result.groupCount(); ++x) {
            vars.put(namep + "_g" + x, result.group(x));
        }
    }

    private static void saveGroups(MatchResult result, String namep, JMeterVariables vars) {
        for (int x = 0; x < result.groups(); ++x) {
            vars.put(namep + "_g" + x, result.group(x));
        }
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    private static String generateResult(MatchResult match, String namep, Object[] template, JMeterVariables vars) {
        RegexFunction.saveGroups(match, namep, vars);
        StringBuilder result = new StringBuilder();
        for (Object t : template) {
            if (t instanceof String) {
                result.append(t);
                continue;
            }
            result.append(match.group(((Integer)t).intValue()));
        }
        if (!namep.isEmpty()) {
            vars.put(namep, result.toString());
        }
        return result.toString();
    }

    private static String generateResult(java.util.regex.MatchResult match, String namep, Object[] template, JMeterVariables vars) {
        RegexFunction.saveGroups(match, namep, vars);
        StringBuilder result = new StringBuilder();
        for (Object t : template) {
            if (t instanceof String) {
                result.append(t);
                continue;
            }
            result.append(match.group((Integer)t));
        }
        if (!namep.isEmpty()) {
            vars.put(namep, result.toString());
        }
        return result.toString();
    }

    public String getReferenceKey() {
        return KEY;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 2, 7);
        this.values = parameters.toArray();
    }

    private Object[] generateTemplate(String rawTemplate) {
        if (USE_JAVA_REGEX) {
            return RegexFunction.generateTemplateWithJavaRegex(rawTemplate);
        }
        return this.generateTemplateWithOroRegex(rawTemplate);
    }

    private static Object[] generateTemplateWithJavaRegex(String rawTemplate) {
        ArrayList<Object> pieces = new ArrayList<Object>();
        Matcher matcher = templatePatternJava.matcher(rawTemplate);
        int pos = 0;
        while (matcher.find()) {
            if (pos < matcher.start()) {
                pieces.add(rawTemplate.substring(pos, matcher.start()));
            }
            pieces.add(Integer.valueOf(matcher.group(1)));
            pos = matcher.end();
        }
        if (pos < rawTemplate.length()) {
            pieces.add(rawTemplate.substring(pos));
        }
        return pieces.toArray();
    }

    private Object[] generateTemplateWithOroRegex(String rawTemplate) {
        ArrayList pieces = new ArrayList();
        ArrayList<Integer> combined = new ArrayList<Integer>();
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        Util.split(pieces, (PatternMatcher)matcher, (org.apache.oro.text.regex.Pattern)this.templatePattern, (String)rawTemplate);
        PatternMatcherInput input = new PatternMatcherInput(rawTemplate);
        boolean startsWith = RegexFunction.isFirstElementGroup(rawTemplate);
        if (startsWith) {
            pieces.remove(0);
        }
        Iterator iter = pieces.iterator();
        while (iter.hasNext()) {
            boolean matchExists = matcher.contains(input, this.templatePattern);
            if (startsWith) {
                if (matchExists) {
                    combined.add(Integer.valueOf(matcher.getMatch().group(1)));
                }
                combined.add((Integer)iter.next());
                continue;
            }
            combined.add((Integer)iter.next());
            if (!matchExists) continue;
            combined.add(Integer.valueOf(matcher.getMatch().group(1)));
        }
        if (matcher.contains(input, this.templatePattern)) {
            combined.add(Integer.valueOf(matcher.getMatch().group(1)));
        }
        return combined.toArray();
    }

    private static boolean isFirstElementGroup(String rawData) {
        if (USE_JAVA_REGEX) {
            return FIRST_ELEMENT_PATTERN.matcher(rawData).find();
        }
        org.apache.oro.text.regex.Pattern pattern = JMeterUtils.getPatternCache().getPattern("^\\$\\d+\\$", 32768);
        return JMeterUtils.getMatcher().contains(rawData, pattern);
    }

    static {
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_1"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_2"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_3"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_4"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_5"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
        desc.add(JMeterUtils.getResString((String)"regexfunc_param_7"));
        USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");
    }
}

