/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicReference;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.internal.AetherBasedResolver;
import org.ops4j.pax.url.mvn.internal.Connection;
import org.ops4j.pax.url.mvn.internal.config.MavenConfigurationImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.ops4j.util.property.DictionaryPropertyResolver;
import shaded.org.ops4j.util.property.PropertyResolver;

public class Activator
extends AbstractURLStreamHandlerService
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleContext m_bundleContext;
    private ServiceRegistration<URLStreamHandlerService> m_handlerReg;
    private ServiceRegistration<ManagedService> m_managedServiceReg;
    private final AtomicReference<MavenResolver> m_resolver = new AtomicReference();
    private final AtomicReference<ServiceRegistration<MavenResolver>> m_resolverReg = new AtomicReference();

    public void start(BundleContext bundleContext) {
        this.m_bundleContext = bundleContext;
        this.updated(null);
        this.registerManagedService();
        this.registerHandler();
    }

    public void stop(BundleContext bundleContext) {
        MavenResolver resolver;
        ServiceRegistration registration;
        if (this.m_handlerReg != null) {
            this.m_handlerReg.unregister();
            this.m_handlerReg = null;
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
            this.m_managedServiceReg = null;
        }
        if ((registration = (ServiceRegistration)this.m_resolverReg.getAndSet(null)) != null) {
            registration.unregister();
        }
        if ((resolver = (MavenResolver)this.m_resolver.getAndSet(null)) != null) {
            try {
                resolver.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_bundleContext = null;
        LOG.debug("Handler for protocols mvn stopped");
    }

    private void registerHandler() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("url.handler.protocol", "mvn");
        this.m_handlerReg = this.safeRegisterService(URLStreamHandlerService.class, this, props);
    }

    private void registerManagedService() {
        try {
            this.m_managedServiceReg = OptionalConfigAdminHelper.registerManagedService(this);
        }
        catch (Throwable ignore) {
            this.updated(null);
            this.m_managedServiceReg = null;
        }
    }

    public void updated(Dictionary<String, ?> config) {
        PropertyResolver propertyResolver = config == null ? new PropertyResolver(){

            @Override
            public String get(String propertyName) {
                return Activator.this.m_bundleContext.getProperty(propertyName);
            }
        } : new DictionaryPropertyResolver(config);
        MavenConfigurationImpl mavenConfig = new MavenConfigurationImpl(propertyResolver, "org.ops4j.pax.url.mvn");
        AetherBasedResolver resolver = new AetherBasedResolver(mavenConfig);
        MavenResolver oldResolver = this.m_resolver.getAndSet(resolver);
        ServiceRegistration<AetherBasedResolver> registration = this.safeRegisterService(MavenResolver.class, resolver, null);
        if ((registration = this.m_resolverReg.getAndSet(registration)) != null) {
            registration.unregister();
        }
        if (oldResolver != null) {
            try {
                oldResolver.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new Connection(url, this.m_resolver.get());
    }

    private <T> ServiceRegistration<T> safeRegisterService(Class<T> clazz, T service, Dictionary<String, ?> properties) {
        Method[] methods;
        for (Method method : methods = BundleContext.class.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!"registerService".equals(method.getName()) || params.length != 3 || !String.class.equals(params[0]) || !Object.class.equals(params[1]) || !Dictionary.class.equals(params[2])) continue;
            try {
                return (ServiceRegistration)method.invoke((Object)this.m_bundleContext, clazz.getName(), service, properties);
            }
            catch (Exception e) {
                LOG.error("Unable to register service {}", service, (Object)e);
                return null;
            }
        }
        LOG.error("Method registerService is not found in BundleContext");
        return null;
    }

    static class OptionalConfigAdminHelper {
        OptionalConfigAdminHelper() {
        }

        static ServiceRegistration<ManagedService> registerManagedService(final Activator activator) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", "org.ops4j.pax.url.mvn");
            return activator.safeRegisterService(ManagedService.class, new ManagedService(){

                public void updated(Dictionary<String, ?> dictionary) throws ConfigurationException {
                    activator.updated(dictionary);
                }
            }, props);
        }
    }
}

