/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.lock;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.main.lock.Lock;
import org.apache.karaf.main.lock.Statements;
import org.apache.karaf.main.util.BootstrapLogManager;

public class DefaultJDBCLock
implements Lock {
    final Logger LOG = Logger.getLogger(this.getClass().getName());
    private static final String PROPERTY_LOCK_URL = "karaf.lock.jdbc.url";
    private static final String PROPERTY_LOCK_JDBC_DRIVER = "karaf.lock.jdbc.driver";
    private static final String PROPERTY_LOCK_JDBC_USER = "karaf.lock.jdbc.user";
    private static final String PROPERTY_LOCK_JDBC_PASSWORD = "karaf.lock.jdbc.password";
    private static final String PROPERTY_LOCK_JDBC_TABLE = "karaf.lock.jdbc.table";
    private static final String PROPERTY_LOCK_JDBC_CLUSTERNAME = "karaf.lock.jdbc.clustername";
    private static final String PROPERTY_LOCK_JDBC_TIMEOUT = "karaf.lock.jdbc.timeout";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_USER = "";
    private static final String DEFAULT_TABLE = "KARAF_LOCK";
    private static final String DEFAULT_CLUSTERNAME = "karaf";
    private static final String DEFAULT_TIMEOUT = "10";
    final Statements statements;
    Connection lockConnection;
    String url;
    String driver;
    String user;
    String password;
    String table;
    String clusterName;
    int timeout;

    public DefaultJDBCLock(Properties props) {
        BootstrapLogManager.configureLogger(this.LOG);
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.driver = props.getProperty(PROPERTY_LOCK_JDBC_DRIVER);
        this.user = props.getProperty(PROPERTY_LOCK_JDBC_USER, "");
        this.password = props.getProperty(PROPERTY_LOCK_JDBC_PASSWORD, "");
        this.table = props.getProperty(PROPERTY_LOCK_JDBC_TABLE, DEFAULT_TABLE);
        this.clusterName = props.getProperty(PROPERTY_LOCK_JDBC_CLUSTERNAME, DEFAULT_CLUSTERNAME);
        this.timeout = Integer.parseInt(props.getProperty(PROPERTY_LOCK_JDBC_TIMEOUT, DEFAULT_TIMEOUT));
        this.statements = this.createStatements();
        this.init();
    }

    Statements createStatements() {
        Statements statements = new Statements();
        statements.setTableName(this.table);
        statements.setNodeName(this.clusterName);
        return statements;
    }

    void init() {
        try {
            this.createDatabase();
            this.createSchema();
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error occured while attempting to obtain connection", e);
        }
    }

    void createDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSchema() {
        if (this.schemaExists()) {
            return;
        }
        String[] createStatments = this.statements.getLockCreateSchemaStatements(this.getCurrentTimeMillis());
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            for (String stmt : createStatments) {
                this.LOG.info("Executing statement: " + stmt);
                statement.execute(stmt);
            }
            this.getConnection().commit();
            this.closeSafely(statement);
        }
        catch (Exception e) {
            try {
                this.LOG.log(Level.SEVERE, "Could not create schema", e);
                try {
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.closeSafely(statement);
            }
            catch (Throwable throwable) {
                this.closeSafely(statement);
                throw throwable;
            }
        }
    }

    boolean schemaExists() {
        return this.schemaExist(this.statements.getFullLockTableName());
    }

    boolean schemaExist(String tableName) {
        try {
            DatabaseMetaData metadata = this.getConnection().getMetaData();
            return metadata != null && this.checkTableExists(tableName.toLowerCase(), metadata);
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private boolean checkTableExists(String tableName, DatabaseMetaData metadata) throws SQLException {
        try (ResultSet rs = metadata.getTables(null, null, tableName, new String[]{"TABLE"});){
            boolean bl = rs.next();
            return bl;
        }
    }

    @Override
    public boolean lock() {
        boolean result = this.aquireLock();
        if (result) {
            result = this.updateLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean aquireLock() {
        String lockCreateStatement = this.statements.getLockCreateStatement();
        PreparedStatement preparedStatement = null;
        boolean lockAquired = false;
        try {
            preparedStatement = this.getConnection().prepareStatement(lockCreateStatement);
            preparedStatement.setQueryTimeout(this.timeout);
            lockAquired = preparedStatement.execute();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed to acquire database lock", e);
        }
        finally {
            this.closeSafely(preparedStatement);
        }
        return lockAquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLock() {
        String lockUpdateStatement = this.statements.getLockUpdateStatement(this.getCurrentTimeMillis());
        PreparedStatement preparedStatement = null;
        boolean lockUpdated = false;
        try {
            preparedStatement = this.getConnection().prepareStatement(lockUpdateStatement);
            preparedStatement.setQueryTimeout(this.timeout);
            int rows = preparedStatement.executeUpdate();
            lockUpdated = rows == 1;
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed to update database lock", e);
        }
        finally {
            this.closeSafely(preparedStatement);
        }
        return lockUpdated;
    }

    public void log(Level level, String msg, Exception e) {
        this.LOG.log(level, msg, e);
    }

    @Override
    public void release() throws Exception {
        if (this.isConnected()) {
            try {
                this.getConnection().rollback();
            }
            catch (SQLException e) {
                this.LOG.log(Level.SEVERE, "Exception while rollbacking the connection on release", e);
            }
            finally {
                try {
                    this.getConnection().close();
                }
                catch (SQLException ignored) {
                    this.LOG.log(Level.FINE, "Exception while closing connection on release", ignored);
                }
            }
        }
        this.lockConnection = null;
    }

    @Override
    public boolean isAlive() throws Exception {
        if (!this.isConnected()) {
            this.LOG.severe("Lost lock!");
            return false;
        }
        return this.updateLock();
    }

    boolean isConnected() throws SQLException {
        return this.lockConnection != null && !this.lockConnection.isClosed();
    }

    void closeSafely(Statement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                this.LOG.log(Level.SEVERE, "Failed to close statement", e);
            }
        }
    }

    void closeSafely(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.LOG.log(Level.SEVERE, "Error occured while releasing ResultSet", e);
            }
        }
    }

    Connection getConnection() throws Exception {
        if (!this.isConnected()) {
            this.lockConnection = this.createConnection(this.driver, this.url, this.user, this.password);
            this.lockConnection.setAutoCommit(false);
        }
        return this.lockConnection;
    }

    Connection createConnection(String driver, String url, String username, String password) throws Exception {
        if (url.toLowerCase().startsWith("jdbc:derby")) {
            url = url.toLowerCase().contains("create=true") ? url : url + ";create=true";
        }
        try {
            return this.doCreateConnection(driver, url, username, password);
        }
        catch (Exception e) {
            this.LOG.log(Level.SEVERE, "Error occured while setting up JDBC connection", e);
            throw e;
        }
    }

    Connection doCreateConnection(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        Class.forName(driver);
        return DriverManager.getConnection(url, username, password);
    }

    long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

