/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.result.Result;
import aQute.bnd.service.library.LibraryNamespace;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.io.IO;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

class LibraryHandler
implements AutoCloseable {
    final Workspace ws;

    LibraryHandler(Workspace ws) {
        try {
            this.ws = ws;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    void update(Processor p, String library, String header) {
        Parameters es = new Parameters(library);
        for (Map.Entry<String, Attrs> entry : es.entrySet()) {
            try {
                Library we;
                String versionString;
                String name = Processor.removeDuplicateMarker(entry.getKey());
                boolean ignoreErrors = false;
                if (name.startsWith("-")) {
                    name = name.substring(1);
                    ignoreErrors = true;
                }
                if ("file".equals(versionString = (String)entry.getValue().getOrDefault("version", null))) {
                    String where;
                    File dir = p.getFile(name);
                    if (!dir.isDirectory()) {
                        Result<File> result = this.ws.getExpandedInCache("urn:" + dir.toURI(), dir);
                        if (result.isErr()) {
                            this.error(p, header, name, "version = file but the file %s is not a directory nor can it be exanpanded: %s", dir, result.error().get());
                            continue;
                        }
                        dir = result.unwrap();
                    }
                    if ((where = (String)entry.getValue().getOrDefault("where", null)) != null) {
                        dir = IO.getFile(dir, where);
                    }
                    we = new FileLibrary(dir);
                } else {
                    if (versionString != null && !VersionRange.isOSGiVersionRange(versionString)) {
                        this.error(p, header, name, "Invalid version %s", versionString);
                        continue;
                    }
                    we = this.getLibrary(name, versionString);
                }
                if (we == null) {
                    if (ignoreErrors) continue;
                    this.error(p, header, name, "No %s for %s-%s", header, name, versionString);
                    continue;
                }
                ((Library)we).process(p, entry.getValue(), header);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void error(Processor p, String header, String clause, String format, Object ... args) {
        Reporter.SetLocation error = p.error(format, args);
        try {
            Processor.FileLine fl = p.getHeader(header, clause);
            if (fl != null) {
                fl.set(error);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private RepoLibrary getLibrary(String name, String versionRange) throws Exception {
        String filter = LibraryNamespace.filter(name, versionRange);
        return this.ws.findProviders("bnd.library", filter, Workspace.ResourceRepositoryStrategy.ALL).map(c -> new RepoLibrary(name, (Capability)c)).sorted().findFirst().orElse(null);
    }

    @Override
    public void close() throws Exception {
    }

    class FileLibrary
    extends Library {
        final File dir;

        public FileLibrary(File dir) {
            this.dir = dir;
        }

        @Override
        void process(Processor p, Attrs attrs, String header) {
            String path = attrs.getOrDefault("include", this.getDefault(p));
            File incl = IO.getFile(this.dir, path);
            this.doInclude(p, incl, header, this.dir.getName(), this.dir);
        }
    }

    class RepoLibrary
    extends Library
    implements Comparable<RepoLibrary> {
        final String path;
        final Resource resource;
        final String name;
        final Version version;

        RepoLibrary(String name, Capability cap) {
            this.name = name;
            this.path = cap.getAttributes().getOrDefault("path", "library");
            this.version = ResourceUtils.getVersion(cap);
            this.resource = cap.getResource();
        }

        @Override
        void process(Processor p, Attrs attrs, String header) {
            Result<File> cache = LibraryHandler.this.ws.getExpandedInCache(this.resource);
            if (cache.isErr()) {
                LibraryHandler.this.error(p, header, this.name, cache.error().get(), new Object[0]);
                return;
            }
            File root = IO.getFile(cache.unwrap(), this.path);
            if (!root.isDirectory()) {
                LibraryHandler.this.error(p, header, this.name, "No cached expansion for library %s in resource %s", new Object[]{this.name, this.resource});
                return;
            }
            String path = attrs.getOrDefault("include", this.getDefault(p));
            File incl = IO.getFile(root, path);
            this.doInclude(p, incl, header, this.name, this.resource);
        }

        @Override
        public int compareTo(RepoLibrary o) {
            return o.version.compareTo(this.version);
        }
    }

    abstract class Library {
        Library() {
        }

        String getDefault(Processor p) {
            if (p instanceof Workspace) {
                return "workspace.bnd";
            }
            if (p instanceof Run) {
                return "bndrun.bnd";
            }
            if (p instanceof Project) {
                return "project.bnd";
            }
            return "include.bnd";
        }

        void doInclude(Processor p, File in, String header, String name, Object resource) {
            if (!in.exists()) {
                LibraryHandler.this.error(p, header, name, "Cannot include %s from library %s in resource %s", new Object[]{in, name, resource});
                return;
            }
            if (in.isDirectory()) {
                for (File sub : in.listFiles()) {
                    if (!sub.getName().endsWith(".bnd")) continue;
                    this.doInclude(p, sub, header, name, resource);
                }
                return;
            }
            if (in.isFile()) {
                try {
                    p.doIncludeFile(in, false, p.getProperties());
                    return;
                }
                catch (Exception e) {
                    LibraryHandler.this.error(p, header, name, "Failed to include %s from library %s in resource %s", new Object[]{in, name, resource});
                    return;
                }
            }
            LibraryHandler.this.error(p, header, name, "No cached expansion for %s", new Object[]{resource});
        }

        abstract void process(Processor var1, Attrs var2, String var3);
    }
}

